import React from 'react';
import { message } from 'antd';
import { getInfo } from '@/highOrderComponent/Service';

const submitData = (selectRows, roleId) => {
	if (!selectRows.length) {
		message.warning('请先选择一个应用');
		return false;
	} else {
		let content = selectRows.map((x) => {
			return {
				appId: x.id,
				roleId,
			};
		});
		content = JSON.stringify(content);
		const data = {
			roleId,
			op: 'add',
			content,
		};
		return getInfo(data, '/CommonApi/configRoleApply');
	}
};

const deleteData = (ids, roleId) => {
	const data = {
		ids,
		roleId,
		op: 'delete',
	};
	return getInfo(data, '/CommonApi/configRoleApply');
};

const handleButton = (props) => {
	const buttonConfig = [
		{
			name: '批量授权',
			type: 'Normal',
			component: 'Normal',
			handleClick: (selectRows, formValues, getPage, search) => {
				submitData(selectRows, props.roleId).then((x) => {
					props.getAuthorizedApp();
				});
			},
		},
		{
			name: '批量取消授权',
			type: 'Normal222',
			component: 'Normal',
			handleClick: (selectRows, formValues, getPage, search) => {
				if (!selectRows.length) {
					message.warning('请先选择一个应用');
					return false;
				}

				const deleteIds = [];
				for (let item of selectRows) {
					for (let x of props.authorizedApp) {
						if (x.appId === item.id) {
							deleteIds.push(x.id);
						}
					}
				}
				deleteData(deleteIds, props.roleId).then((x) => {
					props.getAuthorizedApp();
				});
			},
		},
	];
	return buttonConfig;
};

export default handleButton;
