import moment from 'moment';
import { Link } from 'react-router-dom';
import React, { Fragment } from 'react';
import { getAppList } from '@/webPublic/Services';
import { redText } from '@/pages/zydxg/CheckManage/PiciSetting/publicFunc';

const width = 110;
const handlePageSearch = (props) => {
	const pageSearch = {
		search: {
			url: '/asdasd/asdgggki',
			field: {
				groupId: {
					//
					required: true,
					defaultValue: props.typeList[0].key,
				},
			},
			getInfo: (data, url) => {
				return getAppList(data);
			},
			giveFieldsToFormValues: true,
			afterFormValuesChange: (key, oldValue, getPage) => {
				getPage();
			},
			responseCallBack: (response) => {
				return response;
			},
			condition: [
				{
					key: 'groupId',
					name: '类别',
					type: 'radioGroup',
					options: props.typeList,
				},
			],
			nameSpan: { big: 2, small: 4 },
			fileSpan: { big: 2, small: 2 },
		},
		tableRowKey: 'id',
		columns: [
			{
				dataIndex: 'groupName',
				title: '类别',
				width,
			},
			{
				dataIndex: 'name',
				title: '应用名',
				width: width + 150,
			},
			{
				dataIndex: 'isAuthorized',
				title: '是否已授权',
				render: (text, record) => {
					//  return '未授权';
					const includesIds = props.authorizedApp.map((x) => {
						return x.appId;
					});
					if (record && record.id && includesIds.includes(record.id)) {
						return redText('已授权');
					} else {
						return '未授权';
					}
				},
			},
		],
	};
	return pageSearch;
};

export default handlePageSearch;
