import React from 'react';
import { message } from 'antd';
import { redText } from '@/pages/zydxg/CheckManage/PiciSetting/publicFunc';
import { isJSON } from '@/webPublic/one_stop_public/copy';
import ConfirmModal from '@/pages/zydzs/AdmissionActivityManage/ActivityPublish/CheckInSituation_parent/ConfirmModal';
import ButtonDiy from '@/baseComponent/ButtonDiy';
import {
	A4Height,
	A4Width,
	defaultConfigInfo,
} from '@/webPublic/zyd_private/DragAndPrint/ViewPrint/config';

/**
 *
 backgroundUrl: "http://scjoyedu.eicp.net:51337/dsf/test108/u/upload/202005/27135813bxl6.jpg"
 callUrl: "/PublicPrintApi/studentCard/printed"
 code: "studentCard"
 config: [{content: "${name}", errCode: "", errLog: "", errMsg: "", fieldCode: "name", fieldFont: "黑体",…},…]
 errCode: ""
 errLog: ""
 errMsg: ""
 hasPrintBackground: true
 high: null
 queryUrl: "/PublicPrintApi/studentCard/query"
 respcode: "00"
 respdesc: ""
 wide: null
 * */

export default ({ configAll, location }) => {
	const outSideData = {
		...configAll,
	};
	delete outSideData.config;
	const { config } = configAll;
	return [
		{
			type: 'basicConfig',
			component: 'ModalForm',
			nameSpan: { big: 8, small: 10 },
			values: {
				...outSideData,
				info: !outSideData.info ? JSON.stringify(defaultConfigInfo) : outSideData.info,
			},
			url: '/PublicPrintApi/update',
			name: '基础项配置',
			beforeSubmit: (props, formValues) => {
				if (formValues && formValues.backgroundUrl && isJSON(formValues)) {
					formValues.backgroundUrl = JSON.parse(formValues.backgroundUrl).url;
				}
				if (
					formValues &&
					formValues.backgroundUrl &&
					typeof formValues.backgroundUrl === 'object'
				) {
					formValues.backgroundUrl = formValues.backgroundUrl.url;
				}
				const data = {
					...outSideData,
					...formValues,
				};
				delete data.config;
				return data;
			},
			fields: [
				{
					key: 'code',
					name: '编码',
					type: 'input',
					disabled: true,
				},
				{
					key: 'backgroundUrl',
					name: '背景模版图片',
					required: true,
					type: 'buttonUpload',
					accept: 'image/*',
				},
				{
					key: 'hasPrintBackground',
					name: '是否打印背景模版',
					type: 'select',
					options: [
						{
							key: 'true',
							name: '打印',
						},
						{
							key: 'false',
							name: '隐藏',
						},
					],
				},
				{
					key: 'printMeth',
					name: '打印方向',
					type: 'select',
					options: [
						{
							key: '1',
							name: '横向',
						},
						{
							key: '2',
							name: '竖向',
						},
					],
				},
				{
					key: 'high',
					name: '渲染HTML高度(单位厘米)',
					type: 'inputNumber',
					precision: 1,
					min: 5,
					max: 200,
				},
				{
					key: 'wide',
					name: '渲染HTML宽度(单位厘米)',
					type: 'inputNumber',
					precision: 1,
					min: 5,
					max: 200,
				},
				{
					key: 'info',
					name: '其他配置信息JSON',
					type: 'textarea',
				},
				{
					type: 'component',
					render: () => {
						return (
							<p style={{ color: 'red' }}>
								提示:
								{'{"paperHeight":"29.7cm","paperWidth":"21cm"} A4渲染高度28.5 A4渲染宽度19.7'}
							</p>
						);
					},
				},
			],
		},
		{
			type: 'return',
			name: '返回',
			component: 'RenderComponent',
			render: () => {
				if (location && location.state) {
					return (
						<ButtonDiy
							name="返回"
							className="defaultRed"
							key={'return'}
							handleClick={() => {
								window.history.back(-1);
							}}
						/>
					);
				} else {
					return null;
				}
			},
		},
		{
			type: 'remark',
			name: '备注',
			component: 'RenderComponent',
			render: () => {
				return <span key={'remark'}>{redText('谨慎修改,如不清楚配置项意义,请联系开发人员.')}</span>;
			},
		},
	];
};
