import React, { Fragment } from 'react';
import { InputNumber, message } from 'antd';
import {
	defaultConfigInfo,
	defaultItemConfigInfo,
	fieldTypeList,
	fontFamilyList,
	templateCode,
} from '@/webPublic/zyd_private/DragAndPrint/ViewPrint/config';
import { getInfo } from '@/highOrderComponent/Service';

const saveItemConfig = (data, getPage) => {
	if (typeof data.newY !== 'undefined' || typeof data.newX !== 'undefined') {
		let info = { ...data };
		info.x = (typeof data.newX !== 'undefined' && data.newX) || info.x;
		info.y = (typeof data.newY !== 'undefined' && data.newY) || info.y;
		getInfo(
			{
				contentStr: JSON.stringify([info]),
			},
			'/PublicPrintApi/update',
		).then((x) => {
			if (x) {
				getPage();
				message.success('保存成功');
			}
		});
	}
};

const handleColumns = (props) => {
	return [
		{
			dataIndex: 'title',
			title: '字段',
			type: 'input',
		},
		{
			dataIndex: 'content',
			title: '显示内容',
			type: 'input',
		},
		{
			dataIndex: 'mark',
			title: '换行分隔符',
			type: 'input',
		},
		{
			dataIndex: 'fieldType',
			title: '显示类型',
			type: 'select',
			options: fieldTypeList,
			render: (text) => {
				for (let item of fieldTypeList) {
					if (item.key === text) {
						return item.name;
					}
				}
				return text;
			},
		},
		{
			dataIndex: 'high',
			title: '显示高度',
			type: 'inputNumber',
		},
		{
			dataIndex: 'wide',
			title: '显示宽度',
			type: 'inputNumber',
		},
		{
			dataIndex: 'hasHidden',
			title: '是否隐藏',
			type: 'select',
			options: [{ key: 'true', name: '是' }, { key: 'false', name: '否' }],
			render: (text) => {
				return text ? '是' : '否';
			},
		},
		{
			dataIndex: 'fieldFont',
			title: '字体',
			type: 'select',
			options: fontFamilyList,
		},
		{
			dataIndex: 'fieldFontSize',
			title: '文字大小',
			type: 'inputNumber',
			min: 12,
			max: 100,
			precision: 0,
		},
		{
			dataIndex: 'x',
			title: 'x轴偏移量',
			type: 'inputNumber',
			renderConfig: {
				type: 'component',
				render: function({ text, record, getPage }) {
					return (
						<Fragment>
							{text}
							<InputNumber
								precision={0}
								onChange={(value) => {
									record.newX = value;
								}}
								defaultValue={text}
							/>
						</Fragment>
					);
				},
			},
			precision: 0,
		},
		{
			dataIndex: 'y',
			title: 'y轴偏移量',
			type: 'inputNumber',
			precision: 0,
			renderConfig: {
				type: 'component',
				render: function({ text, record, getPage }) {
					return (
						<Fragment>
							{text}
							<InputNumber
								precision={0}
								onChange={(value) => {
									record.newY = value;
								}}
								defaultValue={text}
							/>
						</Fragment>
					);
				},
			},
		},
		{
			dataIndex: 'save',
			title: '保存',
			renderConfig: {
				type: 'component',
				render: function({ text, record, getPage }) {
					return (
						<a
							onClick={() => {
								saveItemConfig(record, getPage);
							}}>
							保存
						</a>
					);
				},
			},
		},
		{
			dataIndex: 'fieldPattern',
			title: '显示格式',
			type: 'input',
		},
		{
			dataIndex: 'transform',
			title: '旋转角度',
			type: 'inputNumber',
			min: 0,
			max: 360,
			precision: 0,
		},
	];
};

const pageSearch = ({ changeConfigAll, configAll, location }) => {
	const columns = handleColumns();
	const fields = columns
		.filter((y) => {
			return y.type;
		})
		.map((x) => {
			if (x.type) {
				return {
					...x,
					name: x.title,
					key: x.dataIndex,
				};
			} else {
				return null;
			}
		});
	fields.push({
		key: 'info',
		name: '其他配置项JSON',
		type: 'textarea',
	});
	columns.push({
		dataIndex: 'operation',
		title: '操作',
		renderConfig: {
			type: 'ModalEdit',
			name: '编辑',
			width: 900,
			fileSpan: { big: 2, small: 2 },
			nameSpan: { big: 7, small: 7 },
			url: '/PublicPrintApi/update',
			fields,
			beforeUpdate: (record, formValues) => {
				formValues.info = formValues.info || JSON.stringify(defaultItemConfigInfo); // 其他配置项JSON
				return {
					contentStr: JSON.stringify([
						{
							...record,
							...formValues,
						},
					]),
				};
			},
			responseCallBack: (response) => {
				if (!response) {
					return false;
				} else {
					return response;
				}
			},
		},
	});

	return {
		search: {
			url: '/PublicPrintApi/query',
			field: {
				code: {
					defaultValue: (location && location.state && location.state.code) || 'studentCard',
					required: true,
				},
			},
			scroll: { x: 'max-content' },
			giveFieldsToFormValues: true,
			responseCallBack: (response) => {
				changeConfigAll(response);
				return response.config;
			},
			afterFormValuesChange: (key, oldValue, getPage) => {
				if (key === 'code') {
					getPage();
				}
			},
			condition: [
				{
					key: 'code',
					name: '业务功能',
					type: 'select',
					options: templateCode.map((x) => {
						return {
							key: x.code,
							name: x.name,
						};
					}),
				},
			],
			nameSpan: { big: 8, small: 9 },
			fileSpan: { big: 4, small: 4 },
		},
		tableRowKey: 'id',
		columns,
	};
};

/****
 * content: "${name}"
 errCode: ""
 errLog: ""
 errMsg: ""
 fieldCode: "name"
 fieldFont: "黑体"
 fieldFontSize: null
 fieldPattern: ""
 fieldType: "0"
 hasHidden: false
 id: 6
 respcode: "00"
 respdesc: ""
 title: "姓名"
 transform: 0
 x: 648
 y: 798
 *
 * */
export default pageSearch;
