/**
 * 打印配置
 * 2020年5月29日 09:52:44
 * 钟是志
 * */

import React, { Component } from 'react';
import pageSetting from './PageSetting';
import pageButton from './PageButton';
import pageSearch from './PageSearch';
import PageTypeMatching from '@/highOrderComponent/PageTypeMatching';
import { getInfo } from '@/highOrderComponent/Service';

class Index extends Component {
	constructor(props) {
		super(props);
		this.state = {
			configAll: {
				config: [],
			},
		};
	}

	changeConfigAll = (configAll) => {
		this.setState({
			configAll,
		});
	};

	componentDidMount() {}

	render() {
		const { configAll } = this.state;
		const { location } = this.props;
		return (
			<PageTypeMatching
				pageSetting={pageSetting}
				pageButton={pageButton({
					configAll,
					location,
				})}
				pageSearch={pageSearch({
					changeConfigAll: this.changeConfigAll,
					configAll,
					location,
				})}
			/>
		);
	}
}

export default Index;
