import { isJSON } from '@/webPublic/zyd_public/utils/utils';
import config from '@/config/config';
import { queryFileUrl } from '@/webPublic/one_stop_public/utils/queryConfig';

export default function getOneStopImgUrl(imgStr = '') {
	if (imgStr && isJSON(imgStr)) {
		imgStr = JSON.parse(imgStr);
		let res = '';
		if (imgStr?.files && Array.isArray(imgStr.files) && imgStr.files.length) {
			res = imgStr.files
				.filter((y) => {
					return y && y.path;
				})
				.map((x) => {
					return {
						path: queryFileUrl(x?.path),
						name: x.name,
					};
				});
		}
		return res;
	} else {
		return imgStr;
	}
}
