// https://www.wangeditor.com/v4/pages/02-%E5%86%85%E5%AE%B9%E5%A4%84%E7%90%86/02-%E8%BF%BD%E5%8A%A0%E6%96%B0%E5%86%85%E5%AE%B9.html
import Editor from '@/webPublic/zyd_public/WangEditor/includes/wangEditor.min';
import { message } from 'antd';
import { uploadFile } from '@/webPublic/one_stop_public/libs/PictureSignature/ShowItem';
import { queryApiActionPath, queryFileUrl } from '@/webPublic/one_stop_public/utils/queryConfig';

const E = Editor;
const { BtnMenu } = E;
window.message = message;

export default class PdfMenu extends BtnMenu {
  constructor(editor) {
    // data-title属性表示当鼠标悬停在该按钮上时提示该按钮的功能简述
    const $elem = E.$(
      `<div class='w-e-menu' data-title='Alert' style='position: relative;' title="导入pdf">
      <svg viewBox='0 0 1024 1024'
           xmlns='http://www.w3.org/2000/svg'
           width='18'
           height='18'
           fill='currentColor'
           >
<path d='M905 179q-10-10-22-21-36-33-67-62-3-2-5-4-45-41-71-63-16-13-25-19-6-5-11-7-6-3-13-3-10 0-17.5 7.5T666 26v230h230l-26-25v767l26-25H230q-31 0-53.5-22.5T154 896V26l-26 26h461q10 0 17.5-7.5t7.5-18-7.5-18T589 1H102v895q0 53 37.5 90.5T230 1024h692V205H691l26 26V26q0 10-7.5 17.5T692 51q-5 0-9-2l2 2q7 5 22 17 25 22 69 62 3 2 5 4 31 28 67 62 12 10 22 20 6 5 8 8 8 7 18.5 7t18-8 7-18.5T914 187q-4-3-9-8zM102 461H0v435h1024V461H102z m106 250v108h-50V528h111q49 0 77.5 25.5T375 621t-28 66-79 24h-60z m0-41h61q27 0 41-12.5t14-36.5-14-38-40-14h-62v101z m211 149V528h86q39 0 69 17t46.5 49 16.5 72v15q0 41-16.5 72.5t-47 48.5-70.5 17h-84z m51-250v210h33q40 0 61-25t22-72v-16q0-47-20.5-72T505 569h-35z m385 127H738v123h-51V528h185v41H738v86h117v41z' />
</svg></div>`,
    );
    super($elem, editor);
  }

  // 菜单点击事件
  clickHandler() {
    // 做任何你想做的事情
    // 可参考【常用 API】文档，来操作编辑器
    let dom = document.createElement('input');
    dom.accept = '.pdf';
    dom.type = 'file';
    dom.onchange = (v) => {
      console.log(v);
      if (dom.files && dom.files.length) {
        window.message.info('正在上传文件, 请耐心等待');
        const file = dom.files[0];
        console.log(file);
        const fileName = file.name;
        uploadFile(file)
          .then((res) => {
            setTimeout(() => {
              if (res && res.length > 10) {
                let url = queryFileUrl(res);
                window.message.success('上传文件成功');
                // 30354 【移动端】家庭经济困难学生认定,手机端这么搞，已通过项目组审核
                // 将 embed 改完iframe 解决移动端不显示pdf 文件的bug
                this.editor.txt.append(`
<p class='wangEditor-aHref'><a href='${url}' target='_blank' download='${fileName}'>${fileName}</a></p>
<p class='wangEditor-pdfReader'>
<iframe width='100%'
       height='768px'
       name='plugin'
       id='plugin'
       src='${window.specialImportantSystemConfig?.pdfReadPrefixUrl ? window.specialImportantSystemConfig?.pdfReadPrefixUrl + url : url}'
       type='application/pdf'
       internalinstanceid='3'
       title='${fileName}'/>
</p>
`);
              }
            }, 2000);

          });
      }
    };
    dom.click();
  }

  // 菜单是否被激活（如果不需要，这个函数可以空着）
  // 1. 激活是什么？光标放在一段加粗、下划线的文本时，菜单栏里的 B 和 U 被激活，如下图
  // 2. 什么时候执行这个函数？每次编辑器区域的选区变化（如鼠标操作、键盘操作等），都会触发各个菜单的 tryChangeActive 函数，重新计算菜单的激活状态
  tryChangeActive() {
    // 激活菜单
    // 1. 菜单 DOM 节点会增加一个 .w-e-active 的 css class
    // 2. this.this.isActive === true
    this.active();

    // // 取消激活菜单
    // // 1. 菜单 DOM 节点会删掉 .w-e-active
    // // 2. this.this.isActive === false
    // this.unActive()
  }
}
