/**
 * 视频上传组件
 * wangEditor http://www.wangeditor.com/  将git 源码下载下来 然后 npm run build 获取编译后的代码 版本 4.2.2
 *
 * */
import Editor from '@/webPublic/zyd_public/WangEditor/includes/wangEditor.min';
import { message } from 'antd';
import { uploadFile } from "@/webPublic/one_stop_public/libs/PictureSignature/ShowItem";
import { queryApiActionPath, queryFileUrl } from '@/webPublic/one_stop_public/utils/queryConfig';
import videoSvg from './video.svg';

const E = Editor;
const { BtnMenu } = E;
window.message = message;

export default class VideoMenu extends BtnMenu {
  constructor(editor) {
    // data-title属性表示当鼠标悬停在该按钮上时提示该按钮的功能简述
    const $elem = E.$(
      `<div class='w-e-menu' data-title='Alert' style='position: relative;'>
<img src='${videoSvg}' alt='video' style='width: 18px;height: 18px;'/>
</div>`,
    );
    super($elem, editor);
  }

  // 菜单点击事件
  clickHandler() {
    // 做任何你想做的事情
    // 可参考【常用 API】文档，来操作编辑器
    let dom = document.createElement('input');
    dom.accept = '.MP4,.Ogg,.WebM,.WAV';
    dom.type = 'file';
    dom.onchange = (v) => {
      if (dom.files && dom.files.length) {
        window.message.info('正在上传文件, 请耐心等待');
        const file = dom.files[0];
        const fileName = file.name;
        uploadFile(file).then((res) => {
          if (res && res.length > 10) {
            let url = queryFileUrl(res);
            setTimeout(()=>{
              window.message.success('上传成功');
              this.editor.txt.append(`
<p class='wangEditor-videoReader' style='text-align: center;'>
<video
      src='${url}'
      style='max-height: 500px; max-width:100%; text-align: center;'
      controls='true'
      controlsList="nodownload noplaybackrate"
      disablePictureInPicture='true'
  />
</p>
<p class='wangEditor-aHref'><a href='${url}' target='_blank' download='${fileName}'>${fileName}</a></p>`);
            }, 2000);

          }
        });
      }
    };
    dom.click();
  }

  // 菜单是否被激活（如果不需要，这个函数可以空着）
  // 1. 激活是什么？光标放在一段加粗、下划线的文本时，菜单栏里的 B 和 U 被激活，如下图
  // 2. 什么时候执行这个函数？每次编辑器区域的选区变化（如鼠标操作、键盘操作等），都会触发各个菜单的 tryChangeActive 函数，重新计算菜单的激活状态
  tryChangeActive() {
    // 激活菜单
    // 1. 菜单 DOM 节点会增加一个 .w-e-active 的 css class
    // 2. this.this.isActive === true
    this.active();

    // // 取消激活菜单
    // // 1. 菜单 DOM 节点会删掉 .w-e-active
    // // 2. this.this.isActive === false
    // this.unActive()
  }
}
