/**
 * wangEditor http://www.wangeditor.com/  将git 源码下载下来 然后 npm run build 获取编译后的代码 版本 4.2.2
 * 钟是志
 * 2020年11月5日 16:56:23
 *
 **/
/**
 * key: 组件的key // 同一页面渲染应该只有一个唯一的key
 * height: number // 编辑区域的高度 单位px
 * zIndex: number // 默认为 10000 可自行设置
 * placeholder: string // 提示文字,
 * focus: boolean, // 是否获取焦点
 * value: string // 富文本的值
 * 更多配置项 参考 http://www.wangeditor.com/doc/
 * */
import React, { useState, useEffect } from 'react';
import WangEditor from './includes/wangEditor.min';
import { uploadFile } from "@/webPublic/one_stop_public/libs/PictureSignature/ShowItem";
import { queryApiActionPath, queryFileUrl } from '@/webPublic/one_stop_public/utils/queryConfig';
import PdfMenu from '@/webPublic/zyd_public/WangEditor/DiyMenu/PdfMenu';
import VideoMenu from '@/webPublic/zyd_public/WangEditor/DiyMenu/VideoMenu';
let editor = null;




export default function Index({
                                height,
                                zIndex,
                                placeholder,
                                focus,
                                value,
                                domKey,
                                onChangeValue,
                                menus,
                              }) {
  useEffect(() => {
    editor = new WangEditor(`#wangEditor${domKey}`);
    editor.menus.extend('PdfMenuKey', PdfMenu);
    editor.menus.extend('video', VideoMenu);
    editor.config.zIndex = 20;
    if (height) {
      editor.config.height = height; // 编辑器高度
    }
    if (zIndex) {
      editor.config.zIndex = zIndex; // 编辑器 z-index
    }
    if (placeholder) {
      editor.config.placeholder = placeholder; // placeholder
    }
    if (focus) {
      editor.config.focus = focus;
    }
    editor.config.onchange = function(newHtml) {
      onChangeValue(newHtml);
    };

    editor.config.onchangeTimeout = 500; // html内容改变时的 timeOut 配置

    editor.config.customUploadImg = function(resultFiles, insertImgFn) {
      // 重写上传图片的方法
      uploadFile(resultFiles[0]).then((y) => {
        if (y && y.length) {
          insertImgFn(queryFileUrl(y));
        }
      });
      // insertImgFn(imgUrl);
    };

    editor.config.pasteFilterStyle = false; // 关闭粘贴样式的过滤
    editor.config.uploadImgMaxSize = 3 * 1024 * 1024; // 上传的图片不能大于3M
    editor.config.uploadImgMaxLength = 1; // 一次最多上传 1 个图片
    editor.config.showFullScreen = false; // 关闭全局变量
    editor.config.menus = menus && menus.filter((g) =>  g !== 'list' && g !== 'table') || [
      // 配置菜单
      'head',
      'bold',
      'fontSize',
      'fontName',
      'italic',
      'underline',
      'strikeThrough',
      'indent',
      'lineHeight',
      'foreColor',
      'backColor',
      'link',
      // 'list', // 不生效 3788 北电行为规范活动，有序无序不生效
      'justify',
      'quote',
      // 'emoticon',
      'image',
      'video',
      // 'table', // 样式会错位 3678 北电思政课程，新增界面富文本中输入显示问题
      // 'code',
      'splitLine',
      'PdfMenuKey',
      // 'undo',
      // 'redo',
    ];

    editor.create();
    editor.txt.html(value);

    return () => {
      console.log('销毁了editor');
      editor.destroy();
    };
  }, []);

  return <div id={`wangEditor${domKey}`} />;
}
