import { uploadFile } from '@/webPublic/one_stop_public/libs/PictureSignature/ShowItem';
import { queryApiActionPath, queryFileUrl } from '@/webPublic/one_stop_public/utils/queryConfig';
import { message } from 'antd';
import { isJSON } from '@/webPublic/one_stop_public/tableCompon/Split_Index/staticInfo';

class MyMenu {
  constructor() {
    this.title = 'pdf上传';
    this.iconSvg = `<svg viewBox='0 0 1024 1024'
           xmlns='http://www.w3.org/2000/svg'
           width='18'
           height='18'
           fill='currentColor'
           >
<path d='M905 179q-10-10-22-21-36-33-67-62-3-2-5-4-45-41-71-63-16-13-25-19-6-5-11-7-6-3-13-3-10 0-17.5 7.5T666 26v230h230l-26-25v767l26-25H230q-31 0-53.5-22.5T154 896V26l-26 26h461q10 0 17.5-7.5t7.5-18-7.5-18T589 1H102v895q0 53 37.5 90.5T230 1024h692V205H691l26 26V26q0 10-7.5 17.5T692 51q-5 0-9-2l2 2q7 5 22 17 25 22 69 62 3 2 5 4 31 28 67 62 12 10 22 20 6 5 8 8 8 7 18.5 7t18-8 7-18.5T914 187q-4-3-9-8zM102 461H0v435h1024V461H102z m106 250v108h-50V528h111q49 0 77.5 25.5T375 621t-28 66-79 24h-60z m0-41h61q27 0 41-12.5t14-36.5-14-38-40-14h-62v101z m211 149V528h86q39 0 69 17t46.5 49 16.5 72v15q0 41-16.5 72.5t-47 48.5-70.5 17h-84z m51-250v210h33q40 0 61-25t22-72v-16q0-47-20.5-72T505 569h-35z m385 127H738v123h-51V528h185v41H738v86h117v41z' />
</svg>`;
    this.tag = 'button';
  }

  getValue(editor) {
    return '';
  }

  isActive(editor) {
    return false; // or false
  }

  isDisabled(editor) {
    return false; // or true
  }

  exec(editor, value) {
    console.log('exec', editor);
    let dom = document.createElement('input');
    dom.accept = '.pdf';
    dom.type = 'file';
    dom.onchange = (v) => {
      console.log(v);
      if (dom.files && dom.files.length) {
        message.info('正在上传文件, 请耐心等待');
        const file = dom.files[0];
        console.log(file);
        const fileName = file.name;
        uploadFile(file)
          .then((res) => {
            setTimeout(() => {
              if (res && typeof res === 'string' && res.length > 10 && res.indexOf('errMsg') <= -1) {
                let url = queryFileUrl(res);
                message.success('上传文件成功');
                const v = `<p class='wangEditor-pdfReader'><embed width='100%'
                                     height='768px'
                                     name='plugin'
                                     id='plugin'
                                     src='${url}'
                                     type='application/pdf'
                                     internalinstanceid='3'
                                     title='${fileName}'/>
                              </p>
                              <p class='wangEditor-aHref'>
                              <a href='${url}'
                                 target='_blank'
                                 download='${fileName}'>
                                ${fileName}
                              </a></p>`;
                editor.dangerouslyInsertHtml(v); //
              }else{
                let text = '上传文件失败';
                if(isJSON(res)){
                  text = text + ',' + JSON.parse(res).errMsg;
                }
                editor.dangerouslyInsertHtml(`<a href="123123">123123</a>`); //
                message.error(text);
              }
            }, 2000);

          });
      }
    };
    dom.click();

  }
}

const myMenuConf = {
  key: 'myMenu',
  factory() {
    return new MyMenu();
  },
};
export default myMenuConf;
