/**
 * @description 编辑器 class
 * @author wangfupeng
 */
import { DomElement } from '../utils/dom-core';
import { ConfigType } from '../config';
import SelectionAndRangeAPI from './selection';
import CommandAPI from './command';
import Text from '../text/index';
import Menus from '../menus/index';
import ZIndex from './z-index';
import Change from './change/index';
import History from './history/index';
import BtnMenu from '../menus/menu-constructors/BtnMenu';
import DropList from '../menus/menu-constructors/DropList';
import DropListMenu from '../menus/menu-constructors/DropListMenu';
import Panel from '../menus/menu-constructors/Panel';
import PanelMenu from '../menus/menu-constructors/PanelMenu';
import Tooltip from '../menus/menu-constructors/Tooltip';
declare class Editor {
    static $: Function;
    static BtnMenu: typeof BtnMenu;
    static DropList: typeof DropList;
    static DropListMenu: typeof DropListMenu;
    static Panel: typeof Panel;
    static PanelMenu: typeof PanelMenu;
    static Tooltip: typeof Tooltip;
    id: string;
    toolbarSelector: string;
    textSelector: string | undefined;
    config: ConfigType;
    $toolbarElem: DomElement;
    $textContainerElem: DomElement;
    $textElem: DomElement;
    toolbarElemId: string;
    textElemId: string;
    isFocus: boolean;
    isComposing: boolean;
    isCompatibleMode: boolean;
    selection: SelectionAndRangeAPI;
    cmd: CommandAPI;
    txt: Text;
    menus: Menus;
    i18next: any;
    highlight: any;
    zIndex: ZIndex;
    change: Change;
    history: History;
    private beforeDestroyHooks;
    /**
     * 构造函数
     * @param toolbarSelector 工具栏 DOM selector
     * @param textSelector 文本区域 DOM selector
     */
    constructor(toolbarSelector: string, textSelector?: string);
    /**
     * 初始化选区
     * @param newLine 新建一行
     */
    initSelection(newLine?: boolean): void;
    /**
     * 创建编辑器实例
     */
    create(): void;
    /**
     * 提供给用户添加销毁前的钩子函数
     * @param fn 钩子函数
     */
    beforeDestroy(fn: Function): Editor;
    /**
     * 销毁当前编辑器实例
     */
    destroy(): void;
    /**
     * 将编辑器设置为全屏
     */
    fullScreen(): void;
    /**
     * 将编辑器退出全屏
     */
    unFullScreen(): void;
    /**
     * 禁用api
     */
    disable(): void;
    /**
     * 启用api
     */
    enable(): void;
}
export default Editor;
