/**
 * wangEditor http://www.wangeditor.com/  将git 源码下载下来 然后 npm run build 获取编译后的代码 版本 4.2.2
 * 钟是志
 * 2020年11月5日 16:56:23
 *
 **/
/**
 * key: 组件的key // 同一页面渲染应该只有一个唯一的key
 * height: number // 编辑区域的高度 单位px
 * zIndex: number // 默认为 10000 可自行设置
 * placeholder: string // 提示文字,
 * focus: boolean, // 是否获取焦点
 * value: string // 富文本的值
 * 更多配置项 参考 http://www.wangeditor.com/doc/
 * */
import React, { useEffect } from 'react';
import WangEditor from './includes/wangEditor.min';
import uploadFile from './uploadFile';
import compressImage from '@/webPublic/zyd_public/WangEditor/compressImage';
import PdfMenu from '@/webPublic/zyd_public/WangEditor/DiyMenu/PdfMenu';
import WordMenu from '@/webPublic/zyd_public/WangEditor/DiyMenu/WordMenu';
import VideoMenu from '@/webPublic/zyd_public/WangEditor/DiyMenu/VideoMenu';
let editor = null;
export default function ZydCmsWangEditor({
	height,
	zIndex,
	placeholder,
	focus,
	value,
	domKey,
	onChangeValue,
}) {
	useEffect(() => {
		editor = new WangEditor(`#wangEditor${domKey}`);
    editor.menus.extend('PdfMenuKey', PdfMenu);
    editor.menus.extend('WordMenuKey', WordMenu);
    editor.menus.extend('video', VideoMenu);
    editor.config.zIndex = 20;
    if (height) {
			editor.config.height = height; // 编辑器高度
		}
		if (zIndex) {
			editor.config.zIndex = zIndex; // 编辑器 z-index
		}
		if (placeholder) {
			editor.config.placeholder = placeholder; // placeholder
		}
		if (focus) {
			editor.config.focus = focus;
		}
		editor.config.onchange = function(newHtml) {
			onChangeValue(newHtml);
		};

		editor.config.onchangeTimeout = 500; // html内容改变时的 timeOut 配置

		editor.config.customUploadImg = function(resultFiles, insertImgFn) {
			// 重写上传图片的方法
      compressImage(resultFiles[0], (fileNew) => {
        // return ;
        uploadFile({ file: fileNew }).then((y) => {
          if (y && y.url) {
            insertImgFn(y.url);
          }
        });
      })

			// insertImgFn(imgUrl);
		};

		editor.config.pasteFilterStyle = false; // 关闭粘贴样式的过滤
		editor.config.uploadImgMaxSize = 10 * 1024 * 1024; // 上传的图片不能大于10M, 胡琳娜说的 图片3M 不够用 改成了10M 钉钉聊天记录
 		editor.config.uploadImgMaxLength = 1; // 一次最多上传 1 个图片
    // editor.config.uploadImgShowBase64 = true;
    editor.config.menus = [
			// 配置菜单
			'head',
			'bold',
			'fontSize',
			'fontName',
			'italic',
			'underline',
			'strikeThrough',
			'indent',
			'lineHeight',
			'foreColor',
			'backColor',
			'link',
			'list',
			'justify',
			'quote',
			// 'emoticon',
			'image',
			'video',
			'table',
			// 'code',
			'splitLine',
      'PdfMenuKey',
			// 'undo',
			// 'redo',
		];
    if(window.specialImportantSystemConfig.importWord){
      editor.config.menus.push('WordMenuKey');
    }

		editor.create();
		if (value && value.indexOf('wangEditorHtml') > -1) {
			editor.txt.html(value);
		} else {
			editor.txt.html('<div class="wangEditorHtml">' + value + '</div>');
		}

		return () => {
			console.log('是否销毁了editor');
			editor.destroy();
		};
	}, []);
	// useEffect(() => {
	//   if (value && editor && editor.txt) {
	//     editor.txt.html('<div class="wangEditorHtml">' + value + '</div>');
	//   }
	// }, [value]);
	return <div id={`wangEditor${domKey}`} />;
}
