import React from 'react';

function checkHtml(htmlStr) {
  let reg = /]+>/g;
  if(!htmlStr || typeof htmlStr !== 'string'){
    return false;
  }
  if(htmlStr.indexOf('<p') > -1 || htmlStr.indexOf('<div') > -1){
    return true;
  }
  return reg.test(htmlStr);
}

export default function TextHtmlReader({ text }) {
  if (checkHtml(text)) {
    return <div dangerouslySetInnerHTML={{ __html: text }} className='textReader'>

    </div>;
  } else {
    return (
      <pre>
        {text}
      </pre>);
  }
}
