import { Button, Drawer, Input, message } from 'antd';
import React, { useEffect, useState, useRef } from 'react';
import { connect } from 'dva';
import ButtonDiy from '@/baseComponent/ButtonDiy';
import moment from 'moment';
import styles from './styles.less';
import { getUserInfo } from '@/webPublic/one_stop_public/utils/token';

const { TextArea } = Input;

function EditDrawer(props) {
	const { dispatch, templateData, TEMPLATE } = props;
	const [loading, setLoading] = useState(false);
  // const [showEdit, setShowEdit] = useState(process.env.NODE_ENV === 'development');
  const [showEdit, setShowEdit] = useState(false);
	const saveTimeOut = useRef();
	const [lowCodeEdit, setLowCodeEdit] = useState({});

	useEffect(
		() => {
			if (templateData) {
				setLowCodeEdit({ ...templateData });
			}
		},
		[templateData],
	);

	const onClose = () => {
		setShowEdit(!showEdit);
	};

	const handleSaveTemplate = () => {
		lowCodeEdit.updateTime = moment().format('YYYY-MM-DD HH:mm:ss');
		const content = JSON.stringify(lowCodeEdit);
		message.info('正在保存数据,请耐心等待');
		setLoading(true);
		dispatch({
			type: 'lowCode_design/saveTemplateApi',
			payload: {
				name: lowCodeEdit.name,
				content,
				TEMPLATE,
			},
			callback: () => {
				saveTimeOut.current = null;
				setLoading(false);
			},
		});
	};
	const changeKey = (value, key) => {
		let newCodeEdit = lowCodeEdit;
		newCodeEdit[key] = value;
		setLowCodeEdit(newCodeEdit);
	};

	// localStorage 事件中获取的state 不是最新的.

	const handleLocalStorageSave = (e) => {
		if (e.key === 'save-low-code-local') {
			const newV = e.newValue;
			if (newV && newV.length > 20) {
				changeKey(newV, 'beforeShow');
				if (!saveTimeOut.current) {
					saveTimeOut.current = window.setTimeout(() => {
						message.info('正在保存');
						handleSaveTemplate();
					}, 500);
				}
			}
		}
	};

	useEffect(
		() => {
			if (lowCodeEdit?.beforeShow) {
				window.addEventListener('storage', handleLocalStorageSave);
			}
			return () => {
				window.removeEventListener('storage', handleLocalStorageSave);
			};
		},
		[lowCodeEdit.beforeShow],
	);

	const editFullScreen = () => {
		localStorage.setItem('edit-low-code-local', JSON.stringify(lowCodeEdit));
		if (process.env.NODE_ENV === 'development') {
			window.open(
				'https://yx.bpi.edu.cn/wisdomYsgz/#/quanPingBianji?id=' + lowCodeEdit.TEMPLATE,
			);
			return;
		}
		window.open(
			window.location.origin + '/wisdomYsgz/#/quanPingBianji?id=' + lowCodeEdit.TEMPLATE,
		);
	};

	return (
		<>
			<Drawer
				title="编辑"
				placement="right"
				onClose={onClose}
				visible={showEdit}
				width={700}
				maskClosable={false}>
				<TextArea
					autoSize={{
						minRows: 5,
						maxRows: 10,
					}}
					value={JSON.stringify(templateData, null, '\t')}
					disabled={true}
					style={{ marginBottom: '20px' }}
				/>

				{loading ? (
					'正在保存中请勿编辑'
				) : (
					<>
						挂载前执行
						<ButtonDiy name={'全屏编辑'} handleClick={editFullScreen} type={'danger'} />
						<TextArea
							autoSize={{
								minRows: 10,
								maxRows: 15,
							}}
							defaultValue={lowCodeEdit?.beforeShow || ''}
							onChange={(e) => {
								changeKey(e.target.value, 'beforeShow');
							}}
							// readOnly={true}
							style={{ marginBottom: '20px' }}
						/>
						<Button onClick={handleSaveTemplate} type={'primary'}>
							保存
						</Button>
					</>
				)}
			</Drawer>
			<div
				data-edit-point={'EditDrawer'}
				className={styles.editPoint}
				style={{
					display: process.env.NODE_ENV === 'development' ? 'block' : 'none',
				}}
				onClick={() => {
					setShowEdit(!showEdit);
				}}>
				模板编辑
			</div>
		</>
	);
}

export default connect(({ lowCode_design }) => {
	return {
		templateData: lowCode_design.templateData,
	};
})(EditDrawer);
