import { getToken, getUserInfo } from '@/webPublic/one_stop_public/utils/token';
import {
  getSassApiHeader,
  getSysCode,
} from '@/webPublic/one_stop_public/2023yunshangguizhou/utils';
import { getIsBei_Dian } from '@/webPublic/zyd_public/utils/utils';
import { getUrlInfo } from '@/webPublic/one_stop_public/DetailForAudit/utils';

export function getVisitorToken() {
	let token = getToken();
	const visitor_client =
		sessionStorage.getItem('visitor_client') === 'true' || !!getUrlInfo().visitor;
	if (visitor_client && (token === 'null' || !token)) {
		// 访客token 欢哥喊加的
		token = '704d693b-cc68-49a7-8888-4acc73b5ca73';
	}
	return token;
}

export function getHeaders(url = '', headersApi = undefined) {
	let token = getVisitorToken();
	const res = {
		headers: getSassApiHeader(),
	};
	if (process.env.NODE_ENV === 'development' && getIsBei_Dian()) {
		res.headers.env = 'test';
	}
	if (url && typeof url === 'string' && url.indexOf('oauthPub=true') > -1) {
		// 公共接口不需要token
		return res;
	}
	if (!token || token === 'null') {
		return res;
	} else {
	//	res.headers.Authorization = `bearer ${token}`; // 这个必须要带上
	}

	return res;
}
