/**
 * 只包含一站式流程的申请页面 会带部分字段参数到申请表单
 * 返回也是返回到上一个路由
 * */

import { message } from 'antd';
import React  from 'react';
import { getToken } from '@/utils/authority';

import PageHeaderWrapper from '@/components/PageHeaderWrapper';
import ButtonDiy from '@/baseComponent/ButtonDiy';
import Shell from '@/baseComponent/Shell';
import router from 'umi/router';
import ApplyForZyd from '@/webPublic/one_stop_public/ForZydApply/index';


export default class AffairPage extends React.Component {
	constructor(props) {
		super(props);
		let state = this.props.location.state;
		if (!state || !state.id) {
			console.error('无法获取流程id', 'JustApply.js');
		}
		this.state = {
			workId: state.id,
			init: { ...state },
		};
	}

	componentDidMount() {
		if (!getToken()) {
			message.error('您的数据未同步,请联系管理员!');
			return false;
		}
		return true;
	}

	returnList = () => {
		router.goBack();
	};

	render() {
		const { workId, init } = this.state;
		if (!workId) {
			return null;
		}
		return (
			<PageHeaderWrapper title="">
				<div
					style={{
						visibility: 'visible',
						backgroundColor: '#fff',
						paddingLeft: '24px',
					}}>
					<Shell>
						<div
							style={{
								height: '54px',
								padding: '12px 0 12px 12px',
								display: 'block',
							}}>
							<ButtonDiy
								name="返回"
								className="defaultBlue"
								handleClick={this.returnList}
								icon="arrow-left"
							/>
						</div>
					</Shell>
         <ApplyForZyd
           {...this.props}
           id={workId}
           returnList={this.returnList}
           init={init}
         />
				</div>
			</PageHeaderWrapper>
		);
	}
}
