/**
 * 单招管理
 * 2020年4月30日 15:53:30
 * 钟是志
 * 从数据集成系统中配置一个url
 * 打开一个新窗口
 **/
import React from 'react';
import { getSysConfig, getToken } from '@/utils/authority';
import { Empty } from 'antd';
import * as service from '../publicApiService';
import config from '@/config/config';

export default class OpenNewWindow extends React.Component {
	constructor(props) {
		super(props);
		this.state = {
			workId: null,
		};
	}

	componentDidMount() {
		const { pathname } = this.props.location;
		service.getId(pathname).then((x) => {
			/**
			 * http://scjoyedu.eicp.net:53005/onestop/#/portal/pointToRouter?token=b876a63d-467a-4ad1-99f8-a9a4d8ff18ad&returnUrl=/portal/AffairSkip/1253569911276437504
			 * */
			if (x && x.workId) {
				const { onestopPC } = config;
				const urlHead = onestopPC.split('/#/')[0];
				this.setState({
					workId: x.workId,
				});
				window.open(
					`${urlHead}/#/portal/pointToRouter?token=${getToken()}&returnUrl=/portal/AffairSkip/${
						x.workId
					}`,
				);
			} else {
				console.error(`未获取到一站式配置的路由 ${pathname}`);
			}
		});
	}

	render() {
		const { workId } = this.state;
		if (!workId) {
			return null;
		}
		return (
			<div
				style={{
					width: '100%',
					marginTop: '10%',
					height: '100%',
				}}>
				<Empty description={'请在新窗口中进行违纪申诉'} />
			</div>
		);
	}
}
