/**
 * 事务页面。 根据接口。达到增删发起事务流程
 * 2019年10月23日 09:48:13
 * 钟是志
 *
 * */

import {message, Modal} from 'antd';
import React, {useEffect, useState} from 'react';
import * as service from '../publicApiService';
import * as destructionFunc from '../destruction';
import {Link} from 'dva/router';
import {getApplyPage} from '../publicApiService';
import {getToken} from '@/utils/authority';
import JustApply from './JustApply';
import PageHeaderWrapper from '@/components/PageHeaderWrapper';
import List from './List';
import pageSetting from './pageSetting';
import ButtonDiy from '@/baseComponent/ButtonDiy';
import Shell from '@/baseComponent/Shell';
import {deepCopy, getIsBei_Dian} from '@/webPublic/zyd_public/utils/utils';
import ApplyForZyd from '@/webPublic/one_stop_public/ForZydApply/index';
import rebackButton from '@/webPublic/FormInsertDiy/AffairPage/ApplyPage/ReBackButton';

export default function index(props) {
  const {state = {}} = props.location;
  const [show, setShow] = useState(false);
  useEffect(
    () => {
      setShow(false);
      setTimeout(() => {
        setShow(true);
      }, 100);
    },
    [props.location.pathname],
  );
  if (!show) {
    return null;
  }
  if (state.justApply) {
    return <JustApply {...props} />;
  } else {
    return <AffairPage {...props} />;
  }
}

class AffairPage extends React.Component {
  constructor(props) {
    super(props);
    let pathname = this.props.location.pathname;
    const {workId} = this.props;
    this.state = {
      showIframe: false,
      columns: [],
      pathname,
      workId: workId || '',
      searchCondition: [],
      dataBaseId: '',
      addFields: [], // 新增时填写的字段。
      renderIframe: false,
      allConfigSetInfo: null,
      serviceInfo: null,
    };
  }

  getServiceDetail = (serviceId) => {
    service.getServiceDetail(serviceId).then((res) => {
      this.setState({
        serviceInfo: res,
      });
    });
  };

  getFormDetail = (workId) => {
    service.getFormDetail(workId).then((response) => {
      if (typeof response.unifiedServicePatternModel === 'undefined') {
        return false;
      }
      if (response.serviceId) {
        this.getServiceDetail(response.serviceId);
      }
      destructionFunc.destructionGetDetail(response).then((x) => {
        const {addFields, tableInfo, allConfigSetInfo} = x;
        this.setState(
          {
            addFields,
            tableInfo,
            allConfigSetInfo,
          },
          () => {
            this.giveDetailColumns();
          },
        );
      });
    });
  };

  giveDetailColumns = () => {
    const {columns, workId, dataBaseId, addFields} = this.state;
    const process_status = columns.find((x) => {
      return x.name === 'process_status';
    });
    if (process_status && process_status.dataIndex) {
      process_status.render = (text, record) => {
        return record.statusName || record[process_status.dataIndex];
      };
    }
    let findCz = columns.find((g) => g.dataIndex === 'operation');
    if (!findCz) {
      columns.push({
        dataIndex: 'operation',
        title: '操作',
        fixed: columns.length > 12 ? 'right' : false,
        render: (text, record) => {
          return (
            <Link
              to={{
                pathname: './Detail',
                state: {
                  workId,
                  dataBaseId,
                  record,
                  addFields,
                },
              }}>
              {["reject", "re_apply", "un_audit"].includes(record?.hisTaskListData?.formStatusId) ? "去提交" : "详情"}
            </Link>
          );
        },
      });
    }

    this.setState({
      columns,
    });
  };

  handleButtonSet = () => {
    const {canApply, otherButtons = []} = this.props;
    const {allConfigSetInfo, serviceInfo} = this.state;
    if (!allConfigSetInfo) {
      return [];
    }
    const isCloseStart = allConfigSetInfo?.isCloseStart;

    if (canApply === false || isCloseStart) {
      return [...otherButtons];
    }

    return [
      {
        type: 'add',
        name: '申请',
        component: 'Normal',
        handleClick: () => {
          this.setState(
            {
              showIframe: true,
              renderIframe: true,
            },
            () => {
            },
          );
        },
      },
      ...rebackButton(serviceInfo),
      ...otherButtons,
    ];
  };

  handleSearchSet = () => {
    const {columns, searchCondition} = this.state;
    const {onResponse} = this.props;
    const pageSearch = {
      search: {
        field: {},
        getPageService: getApplyPage,
        responseCallBack: (response) => {
          if (onResponse) {
            onResponse(response);
          }
          return response;
        },
        condition: searchCondition,
        nameSpan: {
          big: 8,
          small: 9,
        },
        fileSpan: {
          big: 4,
          small: 4,
        },
      },
      tableRowKey: 'id',
      columns,
    };
    return pageSearch;
  };

  getColumns = () => {
    const {workId} = this.state;
    service.getColumns(workId).then((response) => {
      if (response && Array.isArray(response)) {
        response = response.filter((x) => {
          return x.title !== '流程进度';
        });
      }

      if (response) {
        this.setState(
          {
            columns: response,
          },
          () => {
            this.getFormDetail(workId);
          },
        );
      }
    });
  };

  initData = () => {
    if (!getToken()) {
      message.error('您的数据未同步,请联系管理员!');
      return false;
    }
    const {pathname} = this.state;
    const {dataBaseId, workId, iframeHeight} = this.props;
    if (dataBaseId || workId) {
      this.setState(
        {
          workId,
          dataBaseId,
        },
        () => {
          this.getColumns();
        },
      );
    } else {
      service.getId(pathname).then((x) => {
        this.setState(
          {
            workId: x.workId,
            dataBaseId: x.dataBaseId,
          },
          () => {
            this.getColumns();
          },
        );
      });
    }

    window.addEventListener(
      'message',
      (event) => {
        if (event.data === 'returnList') {
          this.returnList(true);
        }
        if (event && event.data && event.data.indexOf && event.data.indexOf('iframeHeight') > -1) {
          let height = Number(event.data.split('-')[1]);
          const iframe = document.getElementById('applyIframeId');
          if (iframe) {
            iframe.height = height + (iframeHeight || 50);
          }
        }
      },
      false,
    );

    return true;
  };

  componentDidMount() {
    this.initData();
  }

  componentDidUpdate(prevProps, prevState) {
    if (prevProps.workId !== this.props.workId) {
      this.initData();
    }
  }

  returnList = (needSearchList = false) => {
    const {workId} = this.state;
    this.setState(
      {
        renderIframe: false,
      },
      () => {
        if (needSearchList) {
          this.ListComponent.getPage();
          setTimeout(() => {
            this.getFormDetail(workId);
          }, 2000);
        }
        this.setState({
          showIframe: false,
        });
      },
    );
  };

  render() {
    const {iframeUrlDiy} = this.props;
    const {
      workId,
      dataBaseId,
      addFields,
      showIframe,
      renderIframe,
      allConfigSetInfo,
    } = this.state;
    if (!workId || !allConfigSetInfo) {
      return null;
    }

    let buttons = this.handleButtonSet({});
    let listConfig = pageSetting.listConfig;
    if (!buttons.length) {
      listConfig = deepCopy(listConfig);
      listConfig.buttonArea = false;
    }
    return (
      <PageHeaderWrapper title="">
        <div
          style={{
            display: showIframe ? 'none' : 'block',
          }}>
          <List
            listConfig={listConfig}
            pageButton={buttons}
            pageSearch={this.handleSearchSet({})}
            addFields={addFields}
            ref={(ListComponent) => (this.ListComponent = ListComponent)}
            workId={workId}
            dataBaseId={dataBaseId}
          />
        </div>
        <div
          style={{
            visibility: showIframe ? 'visible' : 'hidden',
            height: showIframe ? 'auto' : '0px',
            width: '100%',
            backgroundColor: '#fff',
            paddingLeft: '24px',
          }}>
          <Shell>
            <div
              style={{
                height: '54px',
                padding: '12px 0 12px 12px',
                display: showIframe ? 'block' : 'none',
              }}>
              <ButtonDiy
                name="返回"
                className="defaultBlue"
                handleClick={this.returnList}
                icon="arrow-left"
              />
            </div>
          </Shell>
          {renderIframe ? (
            iframeUrlDiy ? (
              <iframe
                src={iframeUrlDiy}
                frameBorder={0}
                id="applyIframeId"
                name="applyIframe"
                marginWidth="0"
                marginHeight="0"
                allowTransparency="yes"
                seamless
                scrolling={'auto'}
                style={{
                  width: '100%',
                  minHeight: '800px',
                  overflowY: 'hidden',
                  backgroundColor: '#fff',
                }}
              />
            ) : (
              <ApplyForZyd {...this.props}
                           returnList={this.returnList}
                           id={workId === '1549319936277479424' ? '1590627747913269248' : workId}/>
              /* 姚鑫国说的 北电科违纪要用另外一个id发起  2022年11月10日 */
            )
          ) : null}
        </div>
      </PageHeaderWrapper>
    );
  }
}
