import pageSetting from './pageSetting';
import React, { Component, useContext } from 'react';
import PageHeaderWrapper from '@/components/PageHeaderWrapper';
import ListTab from './ListTab';
import { getHandledPage, getWaitPage } from '../publicApiService';
import AuditModal from '@/webPublic/FormInsertDiy/AuditPage/BatchAudit/AuditModal';
import { ModalInfo } from '@/baseComponent/Modal';
import ButtonDiy from '@/baseComponent/ButtonDiy';
import CreateC from '@/webPublic/FormInsertDiy/ExportComponent/ContextCreate';
import { isJSON } from "@/webPublic/zyd_public/utils/utils";

class AuditPage extends Component {
	constructor(props) {
		super(props);
		this.state = {};
	}

	// componentDidMount() {
	//   console.log(this.context);
	// }

	handleButtonSet = () => {
		const { hasBatchAudit, batchAuditButtonName, noNeedForm, tab2Buttons = [], tab1Buttons } = this.props;
		return {
			tab1: [
        ...tab1Buttons,
				hasBatchAudit
					? {
							type: 'audit',
							component: 'RenderComponent',
							key: 'audit',
							render: ({ selectRows, getPage }) => {
								const disabled = !selectRows || !Array.isArray(selectRows) || !selectRows.length;

								function handleClick(onShow) {
									const taskName = selectRows[0].taskName;
									const differentTask = selectRows
										.slice(1)
										.find((i) => i.taskDefinitionKey !== selectRows[0].taskDefinitionKey);
									if (differentTask) {
										return ModalInfo(
											<div>
												<strong style={{ color: 'red' }}> {differentTask.taskName} </strong>和
												<strong> {taskName} </strong>
												不能一起审核。
												<br />
												请将分开操作。
											</div>,
										);
									}
									onShow();
								}

								return (
									<AuditModal
										selectRows={selectRows}
										getPage={getPage}
										noNeedForm={noNeedForm}
										key={'audit'}>
										{({ onShow }) => (
											<ButtonDiy
												key={'audit'}
												name={batchAuditButtonName || '批量审核'}
												handleClick={() => handleClick(onShow)}
												disabled={disabled}
											/>
										)}
									</AuditModal>
								);
							},
					  }
					: false,
			].filter((i) => i),
			tab2: tab2Buttons,
		};
	};

	handleSearchSet = () => {
		const { columns, searchCondition, allConfigSetInfo } = this.props;
		const tab1 = {
			search: {
				field: {},
				scroll: { x: 'max-content' },
				getPageService: getWaitPage,
				beforeSearchData: (data) => {
					const searcherKeyValue = data.searcherKeyValue && isJSON(data.searcherKeyValue) ? JSON.parse(data.searcherKeyValue) : {};
					for (let item of searchCondition) {
						if (
							typeof data[item.key] !== 'undefined' &&
							item.key !== 'taskDefKey' &&
							item.key !== 'process_status'
						) {
							searcherKeyValue[item.base52] = data[item.key];
						}
					}
					if (searcherKeyValue && Object.keys(searcherKeyValue).length) {
						data.searcherKeyValue = JSON.stringify(searcherKeyValue);
					}

					if (data.process_status) {
						data.formStatusId = data.process_status;
						delete data.process_status;
					}

					return data;
				},
				responseCallBack: (response) => {
					return response;
				},
				condition: searchCondition.filter((g) => {
					if (!allConfigSetInfo.isShowWaitTaskDef) {
						return g.key !== 'taskDefKey';
					} else {
						return true;
					}
				}),
				nameSpan: {
					big: 8,
					small: 9,
				},
				fileSpan: {
					big: 4,
					small: 4,
				},
				...this.context.locationState?.tab1Props?.search,
			},
			tableRowKey: 'id',
			columns,
		};
		const tab2 = {
			search: {
				field: {},
				scroll: { x: 'max-content' },
				getPageService: getHandledPage,
				responseCallBack: (response) => {
					return response;
				},
				beforeSearchData: (data) => {
					let searcherKeyValue = {};
					for (let item of searchCondition) {
						if (
							typeof data[item.key] !== 'undefined' &&
							item.key !== 'taskDefKey' &&
							item.key !== 'process_status'
						) {
							searcherKeyValue[item.base52] = data[item.key];
						}
					}
					if (searcherKeyValue && Object.keys(searcherKeyValue).length) {
						data.searcherKeyValue = JSON.stringify(searcherKeyValue);
					}
					if (data.process_status) {
						data.formStatusId = data.process_status;
						delete data.process_status;
					}
					return data;
				},
				condition: searchCondition.filter((g) => {
					if (!allConfigSetInfo.isShowHandledTaskDef) {
						return g.key !== 'taskDefKey';
					} else {
						return true;
					}
				}),
				nameSpan: {
					big: 8,
					small: 9,
				},
				fileSpan: {
					big: 4,
					small: 4,
				},
				...this.context.locationState?.tab2Props?.search,
			},
			tableRowKey: 'id',
			columns,
		};
		return {
			tab1,
			tab2,
		};
	};

	componentDidMount() {
		if (this.props.setRefInfo) {
			this.props.setRefInfo('AuditPage', this);
		}
	}

	render() {
		const { workId, dataBaseId, addFields, searchCondition } = this.props;

		return (
			<PageHeaderWrapper title="">
				<ListTab
					tabList={pageSetting.tabList}
					pageButton={this.handleButtonSet({})}
					workId={workId}
					dataBaseId={dataBaseId}
					searchCondition={searchCondition}
					addFields={addFields}
					locationState={this.context.locationState}
					pageSearch={this.handleSearchSet({})}
					setRefInfo={this.props.setRefInfo}
					keepAliveData={this.props.keepAliveData}
          dispatch={this.props.dispatch}
				/>
			</PageHeaderWrapper>
		);
	}
}

AuditPage.contextType = CreateC;

export default AuditPage;
