import React, { Component, Fragment } from 'react';
import { Tabs } from 'antd';
import styles from '@/baseComponent/index.less';
import CreateC from '@/webPublic/FormInsertDiy/ExportComponent/ContextCreate';

import Shell from '@/baseComponent/Shell';
import List from './List';

const TabPane = Tabs.TabPane;

class ListTab extends Component {
	constructor(props) {
		super(props);
		const { tabList, keepAliveData } = this.props;
		const tabKeys = Object.keys(tabList);
		let activeKey = this.props.locationState?.activeKey || tabKeys[0];
		if(keepAliveData && keepAliveData.activeKey){
		  activeKey = keepAliveData.activeKey;
    }
		this.state = {
			activeKey: activeKey,
			tabKeys: tabKeys,
		};
	}

	handleChangeTab = (activeKey) => {
	  const { dispatch, keepAliveData } = this.props;
    dispatch({
      type: 'keepAlive/setAuditPageData',
      payload: {
        path: window.location.href.split('#')[1],
        value: {
          ...keepAliveData,
          pageCurrent: 1,

        },
      },
    });
		this.setState(
			{
				activeKey: '-111111',
			},
			() => {
				setTimeout(() => {
					this.setState({
						activeKey: activeKey,
					});
				}, 30);
			},
		);
	};

	componentDidMount() {
		if (this.props.setRefInfo) {
			this.props.setRefInfo('ListTab', this);
		}
	}

	render() {
		const {
			tabList,
			pageSearch,
			pageButton,
			workId,
			dataBaseId,
			addFields,
			searchCondition,
		} = this.props;
		const { activeKey, tabKeys } = this.state;
		return (
			<Fragment>
				<Shell styleShell={{ marginTop: 0 }}>
					{/*<SearchDom />*/}
					<Tabs activeKey={activeKey} className={styles.ListTab} onChange={this.handleChangeTab}>
						{tabKeys.map((item) => {
							return <TabPane tab={tabList[item].name} key={item} />;
						})}
					</Tabs>
				</Shell>
				{tabKeys.map((item) => {
					if (activeKey === item && pageSearch[item]) {
						const search = pageSearch[item].search;
						if (search.mustHaveCondition && !search.condition.length) {
							// 如果配置了 mustHaveCondition 则 必须有搜索条件才渲染页面 保证 搜索条件正常传给后台
							return null;
						}
					}
					return activeKey === item ? (
						<List
							listConfig={tabList[item].listConfig}
							key={item}
							workId={workId}
							addFields={addFields}
							searchCondition={searchCondition}
							dataBaseId={dataBaseId}
							pageSearch={pageSearch[item]}
							pageButton={pageButton[item]}
							setRefInfo={this.props.setRefInfo}
              keepAliveData={this.props.keepAliveData}
						/>
					) : null;
				})}
			</Fragment>
		);
	}
}

ListTab.contextType = CreateC;

ListTab.propTypes = {};
ListTab.defaultProps = {};

export default ListTab;
