/**
 * 钟是志
 * 2019年11月5日
 * 流程引擎 ChildForm组件
 *
 * */

import ButtonDiy from '@/baseComponent/ButtonDiy';
import ModalDiy from '@/baseComponent/ModalDiy';
import React, { Component, Fragment } from 'react';
import { mustHaveValue } from '@/baseComponent/utils';
import { Badge, Icon } from 'antd';
import FormArray from './FormArray';

export default class ChildForm extends Component {
	constructor(props) {
		super(props);
		this.state = {
			showModal: false,
			formValues: [
				{
					formKey: Math.random(),
				},
			],
			requireOtherFiled: {},
		};
	}

	changeShow = () => {
		const { value } = this.props;
		const { showModal } = this.state;
		if (!value || typeof value !== 'object' || !Array.isArray(value)) {
			this.setState({
				formValues: [
					{
						formKey: Math.random(),
					},
				],
				showModal: !showModal,
			});
		} else {
			let formValues = [];
			for (let item of value) {
				formValues.push({
					formKey: Math.random(),
					...item,
				});
			}
			this.setState({
				formValues,
				showModal: !showModal,
			});
		}
	};

	formStateChange = (value, key, index) => {
		let oldValue = this.state.formValues;
		oldValue[index][key] = value;
		this.setState({
			formValues: oldValue,
		});
	};
	addOneForm = () => {
		let oldValue = this.state.formValues;
		oldValue.push({
			formKey: Math.random(),
		});
		this.setState({
			formValues: oldValue,
		});
	};

	deleteOneForm = (index) => {
		let oldValue = this.state.formValues;
		oldValue.splice(index, 1);
		this.setState({
			formValues: oldValue,
		});
	};

	componentDidMount() {}

	handleOk = () => {
		const { formValues } = this.state;
		const { config } = this.props;
		const {
			componentProps: { thisFields },
		} = config;
		for (let item of formValues) {
			if (!mustHaveValue(thisFields, item)) {
				return false;
			}
		}
		this.props.onChange(formValues, config.key);
		this.changeShow();
		return false;
	};

	render() {
		const { showModal, formValues } = this.state;
		const { config, disabled } = this.props;
		const {
			componentProps: { thisFields },
		} = config;
		const modalProps = {
			handleOk: this.handleOk,
			title: config.name,
			handleCancel: this.changeShow,
			width: 800,
		};
		if (disabled) {
			modalProps.footer = null;
		}
		const Fields = [];

		for (let item of thisFields) {
			if (item.comName !== 'Label') {
				Fields.push(item.name);
			}
		}
		const Filter = [];
		for (let item of thisFields) {
			let name = '';
			if (item.defaultValue) {
				name = item.defaultValue.replace(/[\r\n]/g, '');
			}
			if (item.comName === 'Label' && name && Fields.indexOf(name) > -1) {
				continue;
			} else {
				Filter.push(item);
			}
		}

		return (
			<Fragment>
				<ButtonDiy name={disabled ? '查看' : '编辑'} handleClick={this.changeShow} />

				{showModal ? (
					<ModalDiy {...modalProps}>
						{formValues.map((x, index) => {
							return (
								<div
									style={{
										border: '1px solid gray',
										width: '95%',
										margin: '0 auto',
										marginBottom: '15px',
									}}
									key={x.formKey}>
									{disabled ? (
										<Badge
											count={
												<Icon
													type={'check'}
													style={{
														color: '#52c41a',
														paddingTop: '20px',
														paddingRight: '20px',
													}}
												/>
											}>
											<FormArray
												config={thisFields}
												value={x}
												changeValue={(value, key) => {
													this.formStateChange(value, key, index);
												}}
												disabled={disabled}
												nameSpan={{ big: 7, small: 7 }}
												fileSpan={{ big: 2, small: 2 }}
											/>
										</Badge>
									) : (
										<Badge
											count={
												<Icon
													type={'close-circle'}
													onClick={() => {
														this.deleteOneForm(index);
													}}
													style={{
														color: '#f5222d',
														paddingTop: '20px',
														paddingRight: '20px',
													}}
												/>
											}>
											<FormArray
												config={Filter}
												value={x}
												changeValue={(value, key) => {
													this.formStateChange(value, key, index);
												}}
												disabled={disabled}
												nameSpan={{ big: 9, small: 9 }}
												fileSpan={{ big: 2, small: 2 }}
											/>
										</Badge>
									)}
								</div>
							);
						})}
						{disabled ? null : (
							<div style={{ paddingTop: '20px', textAlign: 'center' }}>
								<ButtonDiy name={'新增'} className={'defaultRed'} handleClick={this.addOneForm} />
							</div>
						)}
					</ModalDiy>
				) : null}
			</Fragment>
		);
	}
}
