/**
 * 钟是志
 * 2019年11月4日 17:39:34
 * 流程引擎 TableSelect
 */

import { Divider, Modal, Popconfirm } from 'antd';
import React, { Component, Fragment } from 'react';
import ButtonDiy from '@/baseComponent/ButtonDiy';
import StandardTable from '@/components/StandardTable';
import { Link } from 'react-router-dom';
import { handleSqlData } from '../publicApiService';
import { date, format } from '../../config';
import moment from 'moment';
import { deepCopy } from '@/baseComponent/utils';

export default class TableSelect extends Component {
	constructor(props) {
		super(props);
		this.state = {
			showModal: false,
			formValues: {},
			selectedRows: [],
			showDetail: true,
			list: [],
			pagination: {
				current: 1,
				total: 1,
				pageSize: 10,
				showQuickJumper: true,
				onChange: (current, size) => {
					this.pageChange(current, size);
				},
			},
		};
	}

	handleSelectRows = (rows) => {
		this.setState({
			selectedRows: rows,
		});
	};

	/*formStateChange = (value, key) => {
    let oldValue = this.state.formValues;
    oldValue[key] = value;
    this.setState({
      formValues: oldValue,
    });
  };*/

	showModal = () => {
		this.setState(
			{
				showModal: true,
			},
			() => {
				this.getPeopleInfo();
			},
		);
	};

	pageChange = (current, size) => {
		this.setState(
			{
				pagination: {
					...this.state.pagination,
					current: current,
					pageSize: size,
				},
			},
			() => {
				//  this.getPeopleInfo();
			},
		);
	};

	componentDidMount() {
		// this.getPeopleInfo();
	}

	getPeopleInfo = () => {
		const { config, value } = this.props;
		const {
			componentProps: { sqlKey, allValues, valueName },
		} = config;
		const { pagination, formValues } = this.state;
		const data = {
			...formValues,
			sqlKey,
			allValues,
		};
		data.pageSize = pagination.pageSize;
		data.pageNo = pagination.current;
		handleSqlData(data).then((response) => {
			if (response.total) {
				// 后续增加分页.
			} else {
				pagination.total = response.length;
			}
			for (let item of response) {
				item[valueName] = item[valueName] + '';
			}
			this.setState({
				list: response,
				pagination,
			});
		});
	};

	stateChange = (key, value) => {
		this.setState({
			[key]: value,
		});
	};

	onChange = (value) => {
		const { config } = this.props;
		this.setState(
			{
				showDetail: false,
			},
			() => {
				this.props.onChange(value, config.key);
				setTimeout(() => {
					this.setState({
						showDetail: true,
					});
				}, 50);
			},
		);
	};

	cancelSelect = (record) => {
		const { config } = this.props;
		let value = deepCopy(this.props.value);
		const { labelName, valueName } = config.componentProps;
		if (value && typeof value === 'object' && value.selects) {
			delete value.selects[record[valueName]];
		}
		this.onChange(value);
	};

	handleSelect = (record) => {
		const { config } = this.props;
		let value = deepCopy(this.props.value);
		const { labelName, valueName, isMultiple } = config.componentProps;
		if (typeof value === 'object') {
			if (value.selects && isMultiple === true) {
				value.selects[record[valueName]] = {
					...record,
				};
			} else {
				value.selects = {
					[record[valueName]]: {
						...record,
					},
				};
			}
		} else {
			value = {
				selects: {
					[record[valueName]]: {
						...record,
					},
				},
			};
		}
		this.onChange(value);
	};

	handleColumns = () => {
		const { config, value } = this.props;
		const { showDetail } = this.state;
		const { valueName } = config.componentProps;
		const info = value && typeof value === 'object' && value.selects ? value.selects : {};
		let keys = Object.keys(info);

		const {
			componentProps: { columnsData },
		} = config;
		const { cols } = columnsData;
		let columns = [];
		for (let item in cols) {
			columns.push({
				dataIndex: cols[item].name,
				title: cols[item].title,
				dataType: cols[item].type,
			});
		}
		for (let item of columns) {
			if (item.dataType && date.indexOf(item.dataType) > -1) {
				item.render = (text, record) => {
					if (!text) {
						return '';
					}
					if (!isNaN(parseInt(text, 10)) && parseInt(text, 10) > 10000000) {
						text = parseInt(text, 10);
					}
					return moment(text).format(format[item.dataType]);
				};
			}
		}
		if (columns.length && showDetail) {
			columns.push({
				title: '操作',
				//  fixed: 'right',
				dataIndex: 'operation',
				render: (text, record) => {
					if (keys.indexOf(record[valueName]) > -1) {
						return (
							<a
								style={{ color: 'red' }}
								onClick={() => {
									this.cancelSelect(record);
								}}>
								取消选择
							</a>
						);
					}
					return (
						<a
							onClick={() => {
								this.handleSelect(record);
							}}>
							选择
						</a>
					);
				},
			});
		}
		return columns;
	};

	render() {
		const { config, disabled } = this.props;
		const { labelName, valueName } = config.componentProps;
		const { showModal, list, pagination, selectedRows } = this.state;
		const value = deepCopy(this.props.value);
		const columns = this.handleColumns();

		const info = value && typeof value === 'object' && value.selects ? value.selects : {};
		const re = [];
		for (let item in info) {
			const one = info[item];
			re.push({
				name: one[labelName],
				value: one[valueName],
			});
		}

		return (
			<Fragment>
				{!showModal ? (
					<Fragment>
						<span>
							{re.length
								? re.map((x) => {
										return (
											<span key={x.value}>
												{x.name}
												&nbsp;&nbsp;
											</span>
										);
								  })
								: ''}
						</span>
						{disabled ? null : (
							<ButtonDiy name={'选择'} className={'defaultBlue'} handleClick={this.showModal} />
						)}
					</Fragment>
				) : (
					<Modal
						title={'选择'}
						visible={true}
						width={1200}
						maskClosable={false}
						footer={null}
						onCancel={() => {
							this.stateChange('showModal', false);
						}}>
						<div style={{ overflowY: 'auto', maxHeight: '600px' }}>
							<StandardTable
								rowKey={valueName}
								selectedRows={selectedRows}
								data={{ list, pagination }}
								columns={columns}
								onSelectRow={this.handleSelectRows}
								noSelectRow={true}
							/>
						</div>
					</Modal>
				)}
			</Fragment>
		);
	}
}
