import { Modal, Spin, Form, Input, message } from 'antd';
import { useState, useEffect } from 'react';
import { getHistoryFormDetail, getTaskDefinition } from '../../../Services';
import AuditButton from '@/webPublic/FormInsertDiy/AuditButton';
import RenderForm from '../../RenderForm';

const TextArea = Input.TextArea;

function AuditModal({ form, selectRows, children, getPage, noNeedForm }) {
	const [visible, setVisible] = useState(false);

	function submitCb(res) {
		// ModalInfo(`提交${res ? '成功' : '失败'}！`, { onOk: () => router.goBack() });
		message.info(`提交${res ? '成功' : '失败'}！`);
		setVisible(false);
		getPage();
	}

	const [data, setData] = useState(null);
	const [taskDefinition, setTaskDefinition] = useState({});
	const [configNoNeedForm, setConfigNeedForm] = useState(true);
	const [loading, setLoading] = useState(false);

	useEffect(
		() => {
			if (!visible) {
				return form.resetFields();
			}
			const code = selectRows && selectRows[0] && selectRows[0].code;
			if (typeof code === 'undefined') return;
			setLoading(true);
			getHistoryFormDetail({ code }).then((res) => {
				setLoading(false);
				if (res && !res.errMsg) {
					setData({ ...res, hisTaskForm: { ...res.hisTaskForm, formKeys: [] } });
					getTaskDefinition({
						appId: res.appId,
						key: res.taskDefinitionKey,
					}).then((res2) => {
						if (res2) {
							setTaskDefinition(res2);
							if (res2.id && res2.formProperties) {
								// 从流程的配置项里面去取 批量审批时是否显示表单的配置项
								let check = res2.formProperties.find((g) => g.name === 'batchAuditHiddenForm');
								if (!check || check.expression !== 'true') {
									setConfigNeedForm(false);
								}
							} else {
								setConfigNeedForm(false);
							}
						}
					});
				}
			});
		},
		[visible],
	);

	const footer = data ? (
		<div style={{ padding: 16, textAlign: 'center' }}>
			<AuditButton
				data={data} // 为 'affair/getIdFormDetail' 接口请求到的数据
				callback={submitCb} // 提交完成后回调函数
				form={form} // form表单控件
				selectRows={selectRows}
				taskIds={selectRows.map((i) => i.taskId)}
			/>
		</div>
	) : null;
	const { getFieldDecorator } = form;

	return (
		<>
			{visible && (
				<Modal
					width={900}
					visible={true}
					title="批量审核"
					maskClosable={false}
					footer={footer}
					onCancel={() => setVisible(false)}>
					<Spin spinning={loading}>
						{data && data.isHandle && !!data.taskFormKey && !noNeedForm && !configNoNeedForm ? (
							<RenderForm
								postData={data}
								get="web"
								isCg="no"
								obj={data.hisTaskForm.formData}
								table="new"
								form={form}
							/>
						) : null}
						<div>
							<h3 style={{ padding: 12, paddingBottom: 0, fontWeight: 'bold' }}>审批说明:</h3>
							<span style={{ display: 'block', textAlign: 'center' }}>
								{getFieldDecorator('reason')(
									<TextArea
										placeholder="请输入审批理由"
										style={{ width: '95%', margin: 12, height: 120, color: '#7F8B95' }}
									/>,
								)}
							</span>
						</div>
					</Spin>
				</Modal>
			)}

			{children({ onShow: () => setVisible(true) })}
		</>
	);
}

export default Form.create()(AuditModal);
