import React from 'react';
import PageTypeMatching from '@/highOrderComponent/PageTypeMatching';
import getInfoGenerator from '../getInfoGenerator';

export { DataType } from '../getInfoGenerator';

const defaultNameSpan = { big: 9, small: 9 };
const defaultFieldSpan = { big: 4, small: 4 };

const defaultPageSetting = {
	selectRows: true, // 是否可以行选择,
	paging: true, // 是否可以分页,
	searchArea: true, // 是否拥有 搜索区dom,
	buttonArea: true, // 是否拥有 按钮区,
};

export default function AuditPage({ appId, tab1 = {}, tab2 = {} }) {
	const pageSearch = {
		tab1: {
			search: {
				searchType: 'cascadeSearchNew',
				getInfo: tab1.getInfo || getInfoGenerator(tab1.condition),
				url: '/common/assigneeTasks',
				field: {
					appId: {
						required: true,
						defaultValue: appId,
					},
				},
				condition: tab1.condition || [],
				nameSpan: tab1.nameSpan || defaultNameSpan,
				fileSpan: tab1.fieldSpan || defaultFieldSpan,
			},
			tableRowKey: tab1.tableRowKey || 'buzinessId',
			columns: tab1.columns || [],
		},
		tab2: {
			search: {
				searchType: 'cascadeSearchNew',
				getInfo: tab2.getInfo || getInfoGenerator(tab2.condition),
				url: '/common/assigneeDTasks',
				field: {
					appId: {
						required: true,
						defaultValue: appId,
					},
				},
				condition: tab2.condition || [],
				nameSpan: tab2.nameSpan || defaultNameSpan,
				fileSpan: tab2.fieldSpan || defaultFieldSpan,
			},
			tableRowKey: tab2.tableRowKey || 'id',
			columns: tab2.columns || [],
		},
	};

	const pageButton = {
		tab1: tab1.pageButton || [],
		tab2: tab2.pageButton || [],
	};

	const pageSetting = {
		type: 'listTab', // 页面类型
		tabList: {
			tab1: {
				key: 0,
				name: '待审核',
				listConfig: { ...defaultPageSetting, ...tab1.pageSetting },
			},
			tab2: {
				name: '已审核',
				key: 1,
				listConfig: { ...defaultPageSetting, ...tab2.pageSetting },
			},
		},
	};

	return (
		<PageTypeMatching
			tabsShellStyle={{ marginTop: 0 }}
			pageSetting={pageSetting}
			pageButton={pageButton}
			pageSearch={pageSearch}
		/>
	);
}
