import React, { useEffect, useState } from 'react';
import { connect } from 'dva';
import RenderForm from '../RenderForm';

function Entrance({ id, get = 'web', isCg, form, dispatch }) {
	const [data, setData] = useState(null);

	useEffect(() => {
		dispatch({
			type: 'modileHome/getDetail',
			payload: { id },
			callback: (res) => {
				if (res && !res.errMsg) {
					setData(res);
				}
			},
		});
	}, []);
	return data ? <RenderForm get={get} isCg={isCg} postData={data} form={form} /> : null;
}

export default connect()(Entrance);
