import React from 'react';
import { Select, Input, InputNumber, Button } from 'antd';
const Option = Select.Option;

export default class OrderItem extends React.Component {
	constructor(props) {
		super(props);
		const value = props.value || {};
		this.state = {
			stringX: value.stringX,
		};
	}

	componentWillReceiveProps(nextProps) {
		// Should be a controlled component.
		if ('value' in nextProps) {
			const value = nextProps.value;
			this.setState(value);
		}
	}

	triggerChange = (changedValue) => {
		// Should provide an event to pass value to Form.
		const onChange = this.props.onChange;
		if (onChange) {
			onChange(Object.assign({}, this.state, changedValue));
		}
	};

	changeStringX = (e) => {
		if (!('value' in this.props)) {
			this.setState({ stringX: e });
		}
		this.triggerChange({ stringX: e });
	};

	render() {
		const { stringX } = this.state;

		return (
			<div>
				<span style={{ padding: '0px 10px' }}>
					<Select onChange={this.changeStringX} value={stringX} style={{ width: 200 }}>
						<Option value="desc" key="desc">
							降序
						</Option>
						<Option value="asc" key="asc">
							升序
						</Option>
					</Select>
				</span>
				<span style={{ paddingLeft: 100 }}>
					<Button type="danger" onClick={this.props.deleteOrder}>
						删除
					</Button>
				</span>
			</div>
		);
	}
}
