import React from 'react';
import { Select, Input, InputNumber, Button, DatePicker } from 'antd';
import { date, text, number } from '../config/index';
import moment from 'moment';

const Option = Select.Option;

export default class QueryItem extends React.Component {
	constructor(props) {
		super(props);
		const value = props.value || {};
		this.state = {
			stringX: value.stringX,
			string: value.string,
			disabled: value.disabled || false,
		};
	}

	componentWillReceiveProps(nextProps) {
		// Should be a controlled component.
		if ('value' in nextProps) {
			const value = nextProps.value;
			this.setState(value);
		}
	}

	triggerChange = (changedValue) => {
		// Should provide an event to pass value to Form.
		const onChange = this.props.onChange;
		if (onChange) {
			onChange(Object.assign({}, this.state, changedValue));
		}
	};

	changeNumber = (e) => {
		if (!('value' in this.props)) {
			this.setState({ string: e });
		}
		this.triggerChange({ string: e });
	};
	changeStringX = (e) => {
		var disabled = false;

		if (e == 'IS NOT NULL' || e == 'IS NULL') {
			disabled = true;
		}
		if (!('value' in this.props)) {
			this.setState({ stringX: e, disabled });
		}

		this.triggerChange({ stringX: e, disabled });
	};
	changeString = (e) => {
		if (!('value' in this.props)) {
			this.setState({ string: e.target.value });
		}
		this.triggerChange({ string: e.target.value });
	};
	changeDate = (date) => {
		if (!('value' in this.props)) {
			this.setState({ string: date.format('YYYY-MM-DD HH:mm:ss') });
		}
		this.triggerChange({ string: date.format('YYYY-MM-DD HH:mm:ss') });
	};
	render() {
		const { obj } = this.props;
		const { string, stringX, disabled } = this.state;
		if (obj.options && obj.options.length > 0) {
			return (
				<div>
					{' '}
					<Select onChange={this.changeStringX} value={stringX || '='} style={{ width: 100 }}>
						<Option value="=" key={'='}>
							等于
						</Option>
						<Option value="<>" key={'<>'}>
							不等于
						</Option>
						<Option value="IS NOT NULL" key={'IS NOT NULL'}>
							不为空
						</Option>
						<Option value="IS NULL" key={'IS NULL'}>
							为空
						</Option>
					</Select>
					{disabled ? (
						''
					) : (
						<span style={{ padding: '0px 10px' }}>
							<Select onChange={this.changeNumber} value={string} style={{ width: 200 }}>
								{obj.options.map((r) => (
									<Option key={r.v} value={r.v}>
										{r.l}
									</Option>
								))}
							</Select>
						</span>
					)}
					<Button type="danger" onClick={this.props.deleteQuery}>
						删除
					</Button>
				</div>
			);
		}
		if (text.includes(obj.type)) {
			return (
				<div>
					<Select onChange={this.changeStringX} value={stringX || '='} style={{ width: 100 }}>
						<Option value="=" key={'='}>
							等于
						</Option>
						<Option value="!=" key={'!='}>
							不等于
						</Option>
						<Option value="like" key={'like'}>
							像
						</Option>
						<Option value="IS NOT NULL" key={'IS NOT NULL'}>
							不为空
						</Option>
						<Option value="IS NULL" key={''}>
							为空
						</Option>
					</Select>
					{disabled ? (
						''
					) : (
						<span style={{ padding: '0px 10px' }}>
							<Input
								onChange={this.changeString}
								placeholder="请输入"
								value={string}
								style={{ width: 200 }}
							/>
						</span>
					)}
					<Button type="danger" onClick={this.props.deleteQuery}>
						删除
					</Button>
				</div>
			);
		} else if (number.includes(obj.type)) {
			return (
				<div>
					{' '}
					<Select onChange={this.changeStringX} value={stringX || '='} style={{ width: 100 }}>
						<Option value="=" key={'='}>
							等于
						</Option>
						<Option value="<>" key={'<>'}>
							不等于
						</Option>
						<Option value=">" key={'>'}>
							大于
						</Option>
						<Option value=">=" key={'>='}>
							大于等于
						</Option>
						<Option value="<" key={'<'}>
							小于
						</Option>
						<Option value="<=" key={'<='}>
							小于等于
						</Option>
						<Option value="IS NOT NULL" key={'IS NOT NULL'}>
							不为空
						</Option>
						<Option value="IS NULL" key={'IS NULL'}>
							为空
						</Option>
					</Select>
					{disabled ? (
						''
					) : (
						<span style={{ padding: '0px 10px' }}>
							<InputNumber
								onChange={this.changeNumber}
								placeholder="请输入"
								value={string}
								style={{ width: 200 }}
							/>
						</span>
					)}
					<Button type="danger" onClick={this.props.deleteQuery}>
						删除
					</Button>
				</div>
			);
		} else if (obj.type === 'BIT') {
			return (
				<div>
					<Select onChange={this.changeStringX} value={stringX || '='} style={{ width: 100 }}>
						<Option value="=" key={'='}>
							等于
						</Option>
					</Select>
					{disabled ? (
						''
					) : (
						<span style={{ padding: '0px 10px' }}>
							<Select onChange={this.changeNumber} value={string} style={{ width: 200 }}>
								<Option value={true} key={'true'}>
									是
								</Option>
								<Option value={false} key={'false'}>
									否
								</Option>
							</Select>
						</span>
					)}
					<Button type="danger" onClick={this.props.deleteQuery}>
						删除
					</Button>
				</div>
			);
		} else if (date.includes(obj.type)) {
			return (
				<div>
					<Select onChange={this.changeStringX} value={stringX || '='} style={{ width: 100 }}>
						<Option value="=" key={'='}>
							等于
						</Option>
						<Option value="<>" key={'<>'}>
							不等于
						</Option>
						<Option value=">" key={'>'}>
							大于
						</Option>
						<Option value=">=" key={'>='}>
							大于等于
						</Option>
						<Option value="<" key={'<'}>
							小于
						</Option>
						<Option value="<=" key={'<='}>
							小于等于
						</Option>
						<Option value="IS NOT NULL" key={'IS NOT NULL'}>
							不为空
						</Option>
						<Option value="IS NULL" key={'IS NULL'}>
							为空
						</Option>
					</Select>
					{disabled ? (
						''
					) : (
						<span style={{ padding: '0px 10px' }}>
							<DatePicker
								onChange={this.changeDate}
								showTime
								format="YYYY-MM-DD HH:mm:ss"
								allowClear={false}
								style={{ width: 200 }}
								value={string ? moment(string) : null}
							/>
						</span>
					)}
					<Button type="danger" onClick={this.props.deleteQuery}>
						删除
					</Button>
				</div>
			);
		} else {
			return <span>暂无法处理</span>;
		}
	}
}
