/**
 * 钟是志
 * 2022年9月15日
 * onestopApp1.0
 * */
import React, { useEffect, useState, createContext, useRef } from 'react';
import CheckRecord from '@/webPublic/FormInsertDiy/ExportComponent/CheckRecord'; // 查询类
import Apply from '@/webPublic/FormInsertDiy/AffairPage/ApplyPage'; // 申请
import BatchAudit from '@/webPublic/FormInsertDiy/AffairPage/AuditPage/BatchAudit'; // 批量审批
import Audit from '@/webPublic/FormInsertDiy/AffairPage/AuditPage/index.js'; // 审批
import Detail from '@/webPublic/FormInsertDiy/AffairPage/Detail'; //详情
import { Modal, message, notification, Popconfirm } from 'antd';
import { connect } from 'dva';
import router from 'umi/router';
import ApplyMerge from './ApplyMerge'; // merge
import AuditMerge from './AuditMerge';
import CheckRecordMerge from './CheckRecordMerge';
import CreateC from './ContextCreate';

window.iframeParentComponent = {
	Modal,
	message,
	notification,
	Popconfirm,
};

function ActiveMenuComponent({ routerConfig, ...otherProps }) {
	const { component = '', appId } = routerConfig;
	const refType = useRef();
	const { location } = otherProps;
	const record = location?.state?.record;
	const [show, setShow] = useState(false);
	useEffect(
		() => {
			if ((appId || record.id) && refType.current?.component === component) {
				// 当同一个组件渲染时 切换show 保证重新调接口并渲染页面
				setShow(false);
				setTimeout(() => {
					setShow(true);
				}, 100);
			} else {
				setShow(true);
			}
			refType.current = routerConfig;
		},
		[appId, record],
	);
	if (!show) {
		return null;
	}

	let Res = <div>暂无此功能</div>;

	switch (component) {
		case 'CheckRecord': // 查询类应用
			Res = <>
        <CheckRecord workId={appId} routerConfig={routerConfig}/>
      </>;
			break;
    case 'CheckRecordMerge': // 查询类应用聚合
      Res = <CheckRecordMerge routerConfig={routerConfig}/>;
      break;
		case 'Apply': // 申请类
			if (appId === '1549319936277479424') {
				// 29573 当前位置： 违纪管理/违纪上报（辅导员）,100086 下面这个模块做个超链接 搞到这儿来
				otherProps.otherButtons = [
					{
						type: 'weijiJiangjiLiebiao',
						name: '申诉降级上报',
						component: 'Normal',
						handleClick: () => {
							router.push({
								pathname: '/xg/Violation/downgrade',
							});
						},
					},
				];
			}
			Res = <Apply workId={appId} {...otherProps} routerConfig={routerConfig}/>;
			break;
    case 'ApplyMerage': // 申请页面聚合 多个流程的申请页面放在一起
      Res = <ApplyMerge {...otherProps} routerConfig={routerConfig}/>;
      break;
		case 'Audit': // 审批类
			Res = <Audit workId={appId} {...otherProps} routerConfig={routerConfig}/>;
			break;
		case 'BatchAudit': // 批量审批
			Res = <BatchAudit workId={appId}
                        {...otherProps}
                        routerConfig={routerConfig}
      />;
			break;
    case 'AuditMerage': // 审核页面聚合 多个流程的审核页面放在一起
      Res = <AuditMerge {...otherProps} routerConfig={routerConfig}/>;
      break;
		case 'Detail': // 详情
			Res = <Detail {...otherProps} from={'ActiveMenuComponent.js'}/>;
			break;
		default:
			break;
	}
	return (
		<CreateC.Provider
			value={{
				routerConfig,
        locationState: location?.state,
			}}>
			{Res}
		</CreateC.Provider>
	);
}

export default connect(({}) => {
	return {};
})(ActiveMenuComponent);
