import React, { useEffect, useState } from "react";
import CheckRecord2 from "@/webPublic/FormInsertDiy/AffairPage/IframeFor2.0"; // 2.0的 查询类 应用 直接iframe 嵌入
import Apply from "@/webPublic/FormInsertDiy/AffairPage/ApplyPage"; // 申请
import BatchAudit from "@/webPublic/FormInsertDiy/AffairPage/AuditPage/BatchAudit"; // 批量审批
import Audit from "@/webPublic/FormInsertDiy/AffairPage/AuditPage/index.js"; // 审批
import Detail from "@/webPublic/FormInsertDiy/AffairPage/Detail"; //详情
import { getToken } from "@/utils/authority";
import config from "@/config/config";

export default function ActiveMenuComponent2({
                                               routerConfig,
                                               ...otherProps
                                             }) {
  const { component = "", appId } = routerConfig;
  const [show, setShow] = useState(true);
  useEffect(() => {
    if(appId){
      setShow(false);
      setTimeout(() => {

        setShow(true);
      }, 1000);
    }
  }, [appId]);

  if(!show){
    return null;
  }

  switch (component) {
    case "CheckRecord": // 查询类应用
      console.log(appId);
      return <CheckRecord2 workId={appId} {...otherProps} />;
    case "Apply": // 申请类
      return <Apply
        iframeUrlDiy={config.gateWayPort + `/portal/#/showApplyIframe?id=${appId}&hasSingle=false&token=${getToken()}`}
        // http://localhost:8022/portal/#/showApplyIframe?id=1557980082801213440&hasSingle=false&token=6c994ce4-e9a0-47ff-9223-21877d116265
        iframeHeight={200}
        workId={appId}
        {...otherProps}
      />;
    case "Audit": // 审批类
      return <Audit
        workId={appId}
        {...otherProps} />;
    case "BatchAudit": // 批量审批
      return <BatchAudit
        workId={appId}
        {...otherProps} />;
    case "Detail": // 详情
      return <Detail
        from={routerConfig?.from}
        {...otherProps}
      />;
    default:
      console.log(component, "没有找到此组件");
      return <div>暂无此功能</div>;
  }

}
