import React, { useState, useEffect } from 'react';
import { Tabs } from 'antd';
const TabPane = Tabs.TabPane;
import Apply from '@/webPublic/FormInsertDiy/AffairPage/ApplyPage';
import { isJSON } from '@/webPublic/one_stop_public/copy'; // 申请

export default function ApplyMerge(props) {
  let settingJson = isJSON(props.routerConfig?.settingJson) ? JSON.parse(props.routerConfig?.settingJson) : [];
  if(!settingJson || !Array.isArray(settingJson)){
    console.log('settingJson 不是一个数组 无法渲染!');
    return null;
  }
  const [activeKey, setActiveKey] = useState(settingJson[0].appId);
  const changeActiveKey = (a) => {
    setActiveKey(a);
  };
  useEffect(() => {
  }, []);

  if (!activeKey) {
    return null;
  }
  return (
    <Tabs activeKey={activeKey}
          hideAdd={true}
          style={{backgroundColor:'#fff'}}
          onChange={changeActiveKey}
    >
      {
        settingJson.map((g) => {
          return (<TabPane tab={g.name} key={g.appId}>
            {
              activeKey === g.appId ?
                <Apply workId={g.appId}
                       {...props}
                /> : null
            }
          </TabPane>);
        })
      }
    </Tabs>
  );
}
