import React, { useState, useEffect } from 'react';
import { Tabs } from 'antd';
const TabPane = Tabs.TabPane;
import BatchAudit from '@/webPublic/FormInsertDiy/AffairPage/AuditPage/BatchAudit'; // 批量审批
import Audit from '@/webPublic/FormInsertDiy/AffairPage/AuditPage/index.js'; // 审批
import { isJSON } from '@/webPublic/one_stop_public/copy'; // 申请

export default function AuditMerge(props) {
  let settingJson = isJSON(props.routerConfig?.settingJson) ? JSON.parse(props.routerConfig?.settingJson) : [];
  if(!Array.isArray(settingJson) || !settingJson.length){
    console.log('settingJson 不是一个数组 无法渲染!');
    return null;
  }
  console.log(settingJson);
  const [activeKey, setActiveKey] = useState(settingJson[0].appId);
  const changeActiveKey = (a) => {
    setActiveKey(a);
  };
  useEffect(() => {
  }, []);

  if (!activeKey) {
    return null;
  }
  console.log(settingJson);
  return (
    <Tabs activeKey={activeKey}
          hideAdd={true}
          style={{backgroundColor:'#fff'}}
          onChange={changeActiveKey}
    >
      {
        settingJson.map((g) => {
          const Component = g.type === 'BatchAudit' ? BatchAudit : Audit;
          return (<TabPane tab={g.name} key={g.appId}>
            {
              activeKey === g.appId ?
                <Component workId={g.appId}
                       {...props}
                /> : null
            }
          </TabPane>);
        })
      }
    </Tabs>
  );
}
