/**
 * 解决黔南医保 批量审核时 数据量过大的问题.
 * */
import React, { useEffect, useState } from 'react';
import SpinPercent from './SpinPercent';

export default function ProgressDiy(props) {
	const { componentProps } = props;
	const { progressDefaultProps } = componentProps;
	const [data, setData] = useState(componentProps.data || {});
	const changeData = (newV) => {
	  setData({
      ...newV,
    });
  };

	useEffect(() => {
		if (componentProps) {
			componentProps.changeData = changeData;
		}
	}, []);

	useEffect(() => {
	  if(data){
      componentProps.data = data;
    }
  }, [data]);

	console.log(data);
	return (
		<div>
			<SpinPercent {...data} progressDefaultProps={progressDefaultProps}/>
		</div>
	);
}
