/**
 * 钟是志
 * 2022年8月15日
 * 百分比进度条组件 只负责渲染
 * */
import React, { useEffect, useState, useRef } from 'react';
import { Spin, Progress } from 'antd';
import styles from './styles.less';

export default function SpinPercent(props) {
  const {
    loadingPercent = false,
    percent,
    status,
    total,
    speed,
    message,
    progressDefaultProps,
  } = props;
  if(loadingPercent){
    return (
      <div className={styles.juzhongSpin}>
        <div style={{textAlign: 'center'}}>
          <Progress type='circle'
                    strokeColor={{
                      '0%': '#108ee9',
                      '100%': '#87d068',
                    }}
                    percent={percent}
                    status={status}
                    format={percent => `${speed}/${total}`}
                    {...progressDefaultProps}
          />
          <div className={styles.textCenter}>
            {message}
          </div>
        </div>
      </div>
    );
  }
  return null;
}
