import React, { useState, useEffect } from 'react';
import { Modal, Progress, Button } from 'antd';
import ProgressDiy from './ProgressDiy';

const componentList = {
  ProgressDiy,
};

export default function DiyModal(props) {
  const [show, setShow] = useState(false);
  const changeShow = (s) => {
    setShow(s);
  };
  useEffect(() => {
    window.showDiyModalInfo = {
      // 对外暴露的接口.
      open: () => {
        changeShow(true);
      },
      close: () => {
        changeShow(false);
      },
      ModalProps: {
        title: '自定义弹框',
        width: 1200,
        bodyStyle: {
          minHeight: '50vh',
          overflowY: 'auto',
        },
        maskClosable: false,
        onCancel: () => {
          changeShow(false);
        },
        onOk: () => {
          console.log('点击了确定按钮');
        },
      },
      component: 'ProgressDiy',
      componentProps: {
        progressDefaultProps: {
          type: 'circle',
          strokeColor: {
            '0%': '#108ee9',
            '100%': '#87d068',
          },
          width: 200,
        },
      },
    };
  }, []);

  const Component = window.showDiyModalInfo && !!window.showDiyModalInfo.component
    ? componentList[window.showDiyModalInfo.component]
    : ProgressDiy;
  return (
    <div>
      {
        show &&
        <Modal {...window.showDiyModalInfo?.ModalProps} visible={show}>
          <Component componentProps={window.showDiyModalInfo.componentProps} />
        </Modal>
      }
    </div>
  );
}
