// /**
//  * 钟是志
//  * 2022年9月15日
//  * onestopApp1.0
//  * */
import React from 'react';
import CheckRecord from '@/webPublic/FormInsertDiy/ExportComponent/CheckRecord'; // 查询类
import Apply from '@/webPublic/FormInsertDiy/AffairPage/ApplyPage'; // 申请
import BatchAudit from '@/webPublic/FormInsertDiy/AffairPage/AuditPage/BatchAudit'; // 批量审批
import Audit from '@/webPublic/FormInsertDiy/AffairPage/AuditPage/index.js'; // 审批
import Detail from '@/webPublic/FormInsertDiy/AffairPage/Detail'; //详情
import { connect } from 'dva';
import router from 'umi/router';
import ApplyMerge from './ApplyMerge'; // merge
import AuditMerge from './AuditMerge';
import CheckRecordMerge from './CheckRecordMerge';
import CreateC from './ContextCreate';

function SassOnestopComponent(props){
  const params  = props.match?.params;
  if(!params || !params.appId){
    return '参数错误, 暂无此功能';
  }

  let Res = <div>暂无此功能</div>;

  const routerConfig = {};
  const { type, appId } = params;
    switch (type) {
    case 'CheckRecord': // 查询类应用
      Res = <>
        <CheckRecord workId={appId}/>
      </>;
      break;
    case 'CheckRecordMerge': // 查询类应用聚合
      Res = <CheckRecordMerge />;
      break;
    case 'Apply': // 申请类
      const otherProps = {};
      if (appId === '1549319936277479424') {
        // 29573 当前位置： 违纪管理/违纪上报（辅导员）,100086 下面这个模块做个超链接 搞到这儿来
        otherProps.otherButtons = [
          {
            type: 'weijiJiangjiLiebiao',
            name: '申诉降级上报',
            component: 'Normal',
            handleClick: () => {
              router.push({
                pathname: '/xg/onestop/CheckRecord/1556895593807216640',
              });
            },
          },
        ];
      }
      Res = <Apply workId={appId} {...props} {...otherProps}/>;
      break;
    case 'ApplyMerage': // 申请页面聚合 多个流程的申请页面放在一起
      Res = <ApplyMerge {...props}/>;
      break;
    case 'Audit': // 审批类
      Res = <Audit workId={appId} {...props} />;
      break;
    case 'BatchAudit': // 批量审批
      Res = <BatchAudit workId={appId} {...props}
      />;
      break;
    case 'AuditMerage': // 审核页面聚合 多个流程的审核页面放在一起
      Res = <AuditMerge {...props}/>;
      break;
    case 'Detail': // 详情
      Res = <Detail {...props} />;
      break;
    default:
      break;
  }
  return (
    <CreateC.Provider
      value={{
        routerConfig,
        locationState: props.location?.state,
      }}>
      {Res}
    </CreateC.Provider>
  );
}
export default connect(({}) => {
  return {};
})(SassOnestopComponent);

