import { Tooltip } from 'antd';
import React from 'react';

const formatTreeData = (treeData = [], res = []) => {
	for (let item of treeData) {
		item.title = (
			<>
				<Tooltip title={item.businessMemo}>
					<span>{item.businessName}</span>
				</Tooltip>
			</>
		);
		item.key = item.businessKey || '0000';
		item.checkable = true;
		item.selectable = true;
		if (!item.isSelect) {
			item.selectable = false;
		}
		// if (!item.isSelect) {
		//   item.checkable = false;
		//   item.disabled = true;
		// } else {
		//   item.checkable = true;
		// }
		// item.selectable = item.selectType === 'floor';
		if (item.children && item.children.length) {
			item.children = formatTreeData(item.children, []);
		} else {
			item.isLeaf = true;
		}
	}
	return treeData;
};

const colorTranslate = (item) => {
	const colors = {
		1: '#6164C1',
		2: 'rgb(202, 198, 46)',
		3: '#BE0AC1',
    4: '#d3adf7'
	};
	if (item && item.businessKey) {
	  if(item.businessKey.endsWith("-")){
	    return colors[1];
    }
		return colors[item.businessKey.split('-').length];
	}
	return colors[item.level] || colors['2'];
};

export function getApis(searchType) {
	const apiUrls = {
		// https://console-docs.apipost.cn/preview/caa25e097e7386d0/a2d8620d944c56b5?target_id=fe79cb0e-f0db-49ec-bed9-92f4a830bf75
		instructorSearch: {
			// 查询辅导员
			search: '/instructorSearch/search',
			findTree: '/instructorSearch/findTree',
			findList: '/instructorSearch/findList',
			getData: '/instructorSearch/getData',
			getDataCacheKey: '/instructorSearch/getDataCacheKey',
			readCacheData: '/instructorSearch/readCacheData',
		},
		teacherSearch: {
			// 查询教师
			search: '/teacherSearch/search',
			findTree: '/teacherSearch/findTree',
			findList: '/teacherSearch/findList',
			getData: '/teacherSearch/getData',
			getDataCacheKey: '/teacherSearch/getDataCacheKey',
			readCacheData: '/teacherSearch/readCacheData',
		},
		studentSearch: {
			// 查询学生
			search: '/studentSearch/search',
			findTree: '/studentSearch/findTree',
			findList: '/studentSearch/findList',
			getData: '/studentSearch/getData',
			getDataCacheKey: '/studentSearch/getDataCacheKey',
			readCacheData: '/studentSearch/readCacheData',
		},
	};
	return apiUrls[searchType] || apiUrls.studentSearch;
}

export { formatTreeData, colorTranslate };
