import { uaaRequest } from '@/webPublic/one_stop_public/utils/request';

export const getHead = (payload, callback) => {
	uaaRequest('/DataColumnApi/getHeaderList', payload).then((res) => {
		if (!res) return;
		if (callback) {
			callback(res);
		}
	});
};

export const getDetailId = (payload, callback) => {
	uaaRequest('/UnifiedAppFormApi/getDetailByCode', payload).then((res) => {
		if (!res) return;
		if (callback) callback(res);
	});
};
export const fetchData = (payload, callback) => {
	uaaRequest('/DataObjApi/getFormDataPage', payload).then((res) => {
		if (!res) return;
		if (callback) callback(res);
	});
};

export const deleteItem = (payload, callback) => {
	uaaRequest('/DataObjApi/deleteFormData', payload).then((res) => {
		if (callback) callback(res);
	});
};

export const getDetail = (payload, callback) => {
	uaaRequest('/DataObjApi/getFormData', payload).then((res) => {
		if (res) {
			Object.keys(res).forEach((x) => {
				if (res[x] === 'true') {
					res[x] = true;
				}
				if (res[x] === 'false') {
					res[x] = false;
				}
			});
			if (callback) callback(res);
		}
	});
};

export const add = (payload, callback) => {
	uaaRequest('/DataObjApi/addFormData', {
		data: JSON.stringify(payload.params),
		isAdd: payload.isAdd,
		objId: payload.objId,
	}).then((res) => {
		if (callback) callback(res);
	});
};
