import React, { useState, useEffect } from 'react';
import { Form, Spin } from 'antd';
import Shell from '@/baseComponent/Shell';
import { getHistoryFormDetail } from '../../Services';
import withGoBack from '@/highOrderComponent/withGoBack';
import SubmitButton from '@/webPublic/one_stop_public/AffairButton/SumbitButton';
import { ModalInfo } from '@/baseComponent/Modal';
import RenderForm from '../RenderForm';

function submitCb(res) {
	ModalInfo(`提交${res ? '成功' : '失败'}！`);
}

// 编辑草稿，传入应用id和草稿code
let EditPage = ({ form, appId, draftCode }) => {
	const [data, setData] = useState(null);
	const [loading, setLoading] = useState(false);

	useEffect(() => {
		if (typeof draftCode === 'undefined') return;
		setLoading(true);
		getHistoryFormDetail({ code: draftCode }).then((res) => {
			setLoading(false);
			if (res && !res.errMsg) {
				setData(res);
			}
		});
	}, []);

	return (
		<Shell styleShell={{ marginTop: 0 }}>
			<Spin spinning={loading}>
				{data && (
					<>
						<RenderForm postData={data} form={form} isCg="yes" />
						<div style={{ padding: 16, textAlign: 'center' }}>
							<SubmitButton
								form={form}
								appId={appId}
								draftCode={draftCode}
								text="提交"
								openDraftButton
								DraftButtonText="暂存"
								callback={submitCb}
							/>
						</div>
					</>
				)}
			</Spin>
		</Shell>
	);
};

EditPage = Form.create()(EditPage);

export default ({ hasGoBack = true, ...rest }) => {
	const WithGoBack = withGoBack(EditPage);
	return hasGoBack ? <WithGoBack {...rest} /> : <EditPage {...rest} />;
};
