import RenderForm from "@/webPublic/FormInsertDiy/RenderForm";
import { fetchTemplateById } from '@/webPublic/Services';
import { useState, useEffect, useMemo } from "react";
import { Form } from 'antd';
import { setToken } from '@/utils/authority';
import { getUrlInfo } from '@/webPublic/one_stop_public/DetailForAudit/utils';

function OtherCheckRecord({ form, location: { pathname }, ...props }) {
  const [data, setData] = useState();
  const isMobile = useMemo(() => {
    return getUrlInfo().isMobile || window.screen.width < 768;
  }, []);
  useEffect(() => {
    let params = getUrlInfo();
    let id = params.id || props.id;
    const { token} = params;
    if(token){
      setToken(token);
    }
    if(!id){
      console.error('没有找到id');
    }
    if(isMobile){
      document.body.style.minWidth = 'auto'; // 移动端宽度自适应
    }
    setData(undefined);
    fetchTemplateById(id).then(res => {
      if (res) setData({...res, content: "{}"});
    });
  }, [pathname]);

  return !!data && <RenderForm form={form}
                               postData={data}
                               style={{ padding: 0 }}
                               get={isMobile ? 'mobile' : 'web'}
  />;
}

export default  Form.create()(OtherCheckRecord)
