/**
 * 单页面打印.
 * 打印CheckRecord
 * */
import React, { useEffect, useRef, useState } from 'react';
import ReactToPrint from 'react-to-print';
import styles from './index.less';
import { Button } from 'antd';
import IframeForRenderForm from './IframeForRenderForm';
import { getOneStopConfig } from '@/webPublic/zyd_public/utils/utils';

export default function PrintQnmz(props) {
  const { location: {pathname}, noNeedPrint } = props;
  const componentRef = useRef();
  const [showPrint, setShowPrint] = useState(false);
  const id = props.id || getOneStopConfig(pathname);
  useEffect(() => {
    if(!noNeedPrint){
      setTimeout(() => {
        setShowPrint(true);
      }, 2000);
    }
  }, []);
  return (<div>
    <div id={'showButtonDiv'} className={styles.buttonDiv2}>
      {
        showPrint ? <ReactToPrint
          trigger={() => <Button type={'primary'}>打印</Button>}
          content={() => componentRef.current}
          onBeforePrint={() => {
            return new Promise((resolve, reject) => {
              // let d = document.getElementsByClassName(`antd-pro\\web-public\\one_stop_public\\libs\\form-list\\-table-list-tableListOperator`);
              // if(d && d.length){
              //   console.log(d);
              //   d[0].style.display = 'none';
              // }

              setTimeout(() => {
                resolve(true);
              }, 2000);
            });
          }}
        /> : !noNeedPrint && <div style={{width: '200px'}}>正在加载信息</div>
      }

      {
        showPrint && window.history.length > 1 &&
        <Button type={'danger'} onClick={() => {
          window.history.go(-1);
        }}>返回</Button>
      }
    </div>
    <div ref={componentRef}>
            <div style={{
              minHeight: '21cm',
              minWidth: '29cm',
              width: '38cm',
              pageBreakAfter: 'always',
              display: 'flex',
              // justifyContent: 'center',
              // alignItems: 'center',
            }}
                 id={'printDivDom'}
            >
              <IframeForRenderForm id={id} {...props} />
            </div>
    </div>
  </div>);
}
