import React, { useState } from 'react';
import { Form, Button } from 'antd';
import Shell from '@/baseComponent/Shell';
import { ModalInfo } from '@/baseComponent/Modal';
import { addOrEditTableItem } from '@/webPublic/Services';
import { RenderFormByObjId } from '../RenderForm';
import { preHandle } from '@/webPublic/one_stop_public/utils/myutils';

// 单一数据页面模板，页面只是显示和操作一条数据
// 1. 页面显示通过模板id渲染。
// 2. 页面数据通过元数据表id, key，value 查询和修改。
// templateCode, 页面模板id
// tableId, 元数据列表id
// dataTypeKey, 元数据表格中查找数据的key
// dataTypeValue, 元数据表格中查找数据的value
// children， 可以传children，但children不能是数组(不能传属性)，children里可以自定义其他组件。
// callBackPromise 保存成功后的 回调Promise函数. 用于业务上的需求
function SingleDataPageTemplate(props) {
	const [isAdd, setIsAdd] = useState(false);

	function handleSave() {
		const { tableId, form, callBack } = props;
		const { validateFields } = form;

		validateFields((err, values) => {
			if (err) return;
			// console.log(JSON.stringify(values.JjvkRobXWTE), JSON.stringify(values.JjvkwLqcsyY));
			preHandle(values);
			// console.log(JSON.stringify(values.JjvkRobXWTE));
			addOrEditTableItem({ objId: tableId, isAdd, data: values }).then((res) => {
				if (res) {
					if (callBack) {
						callBack();
					} else {
						ModalInfo('保存成功！');
					}
				}
			});
		});
	}

	const { children, form, templateCode, tableId, dataTypeKey, dataTypeValue } = props;
	let ClonedChildren;
	if (children) {
		ClonedChildren = React.cloneElement(React.Children.only(children), {
			form,
			isAdd,
			url: '/DataObjApi/addFormData',
		});
	}

	return (
		<Shell styleShell={{ marginTop: 0 }}>
			<RenderFormByObjId
				objId={tableId}
				dataTypeKey={dataTypeKey}
				dataTypeValue={dataTypeValue}
				templateCode={templateCode}
				onLoad={(res) => setIsAdd(!!(!res || res.errMsg))}
				form={form}
			/>
			{ClonedChildren || (
				<div style={{ textAlign: 'center', padding: 16 }}>
					<Button type="primary" shape="round" ghost onClick={handleSave}>
						保存
					</Button>
				</div>
			)}
		</Shell>
	);
}

export default Form.create()(SingleDataPageTemplate);
