/**
 * request 网络请求工具 使用公共资源包中的 request方法
 */
import requestJson from '@/webPublic/zyd_public/requestJson/requestJson.js';

function request(url, body, method = 'POST') {
  return requestJson(url, {
    body,
    method,
  })
    .then((x) => {
      if (!x && x !== 0 && x !== false) {
        console.error('接口报错', url, '\n', body);
        return false;
      }
      return x;
    });
}

const prefix = `${window.wisdomSchoolConfig?.systemList?.uia?.service}`;
export { prefix };

export function getUiaInfo(data, url) {
  return request(prefix + url, data);
}

