import { getToken } from '@/webPublic/one_stop_public/utils/getToken';
import { getUserInfo } from '@/webPublic/one_stop_public/utils/token';
import { getIsBei_Dian } from '@/webPublic/zyd_public/utils/utils';

export function isJSON(str) {
	if (typeof str == 'string') {
		try {
			JSON.parse(str);
			if (typeof JSON.parse(str) === 'number') {
				return false;
			}
			return true;
		} catch (e) {
			return false;
		}
	}
}

export const getSysCode = () => {
	return getYunShangGuiZhouSyStemConfig().sysCode || window.specialImportantSystemConfig.sysCode;
	// 钟是志 2023年8月24日 优先从localStorage里面取系统code 取不到才从配置里面取
	// 解决禅道 http://scjoyedu.eicp.net:57400/zentao/task-view-165.html
};

// 查询系统配置
export const getYunShangGuiZhouSyStemConfig = () => {
	const localStorageData = localStorage.getItem('antd-pro-systemConfig');
	if (localStorageData && isJSON(localStorageData)) {
		let d = JSON.parse(localStorageData);
		return {
			sysCode: d.code,
			logo: '',
			name: d.name,
			siteId: '5',
			siteUrl: '',
		};
	} else {
		return {
			sysCode: undefined,
			name: '',
		};
	}
};

export const getSassApiHeader = () => {
	// 解决禅道 34246 在学工、素质测评、宿管、离校的所有接口中增加请求头
	if (!getSysCode() && !window.specialImportantSystemConfig.sysCode) {
		return {
			Authorization: `bearer ${getToken()}`,
			env: process.env.NODE_ENV === 'development' && getIsBei_Dian() ? 'test' : undefined,
		};
	} else {
		return {
			Authorization: `bearer ${getToken()}`,
			sysCode: getSysCode(),
			tenant: getUserInfo().tenantCode || window.specialImportantSystemConfig.tenant || null,
		};
		// 解决禅道 http://scjoyedu.eicp.net:57400/zentao/task-view-165.html
	}
};
