/**
 * 徐立
 * 2019年9月29日
 * 该组件为按钮设计汇总，通过传入get值调取对应组件
 * btn+数字，为对应按钮方法，从左到右计算
 * 以下为样式类名说明
 * .btn_margin 按钮右边距
 * .btn 按钮通用样式
 * .btn_no 不通过专属样式
 * .btn_reject 驳回专属样式
 * 以下为自定义按钮数组说明
 * btnList 为传入数组，具体参数参考为以下
 * [
 * {
 *  type:primary, // 按钮基础样式 参考antd
 *  click:()=>{}, // 点击事件
 *  style:{}, // 自定义按钮样式,传入为对象
 *  content: '', // 自定义按钮内容
 *  margin: boolean, // 是否使用默认margin
 * }
 * ]
 */
import React, { Component } from 'react';
import { Button } from 'antd';
import styleList from './styleList.js';
import Item from 'antd-mobile/lib/popover/Item';

export default class pagesBtn extends Component {
  render() {
    let {
      get,
      btnOne,
      disabled, // 按钮控制状态
      btnTwo,
      btnThree,
      btnList, // 自定义按钮时使用，传入数组进行按钮组装
      style, // 自定义单个按钮样式
      text, // 自定义按钮文本
      isSumbitLoading, // 提交状态
    } = this.props;
    switch (get) {
      /**
       * 常用于发起流程底部按钮
       */
      case '1':
        return (
          <div style={styleList.btn_page}>
            <Button
              style={{ ...styleList.btn_margin, ...styleList.btn }}
              disabled={disabled}
              onClick={btnOne}
              loading={isSumbitLoading}>
              暂存草稿
            </Button>
            <Button
              loading={isSumbitLoading}
              style={{ ...styleList.btn }}
              onClick={btnTwo}
              disabled={disabled}
              type='primary'>
              提交
            </Button>
          </div>
        );
      /**
       * 常用于审核用底部按钮
       */
      case '2':
        return (
          <div style={styleList.btn_page}>
            <Button
              disabled={disabled}
              style={{ ...styleList.btn_margin, ...styleList.btn, ...styleList.btn_no }}
              onClick={btnOne}
              loading={isSumbitLoading && isSumbitLoading}>
              不通过
            </Button>
            <Button
              disabled={disabled}
              loading={isSumbitLoading && isSumbitLoading}
              style={{ ...styleList.btn_margin, ...styleList.btn, ...styleList.btn_reject }}
              onClick={btnTwo}>
              驳回
            </Button>
            <Button
              disabled={disabled}
              style={{ ...styleList.btn }}
              type='primary'
              loading={isSumbitLoading && isSumbitLoading}
              onClick={btnThree}>
              通过
            </Button>
          </div>
        );
      /**
       * 查询类底部按钮
       */
      case '3':
        return (
          <div style={styleList.btn_page}>
            <Button
              disabled={disabled}
              style={{ ...styleList.btn }}
              type='primary'
              onClick={btnOne}
              loading={isSumbitLoading && isSumbitLoading}>
              查询
            </Button>
          </div>
        );
      /**
       * 模态框常用底部按钮
       */
      case '4':
        return (
          <div style={styleList.btn_page}>
            <Button
              disabled={disabled}
              style={{ ...styleList.btn_margin, ...styleList.btn }}

              onClick={btnOne}
              loading={isSumbitLoading && isSumbitLoading}>
              取消
            </Button>
            <Button
              disabled={disabled}
              style={{ ...styleList.btn }}

              type='primary'
              onClick={btnTwo}
              loading={isSumbitLoading && isSumbitLoading}>
              确定
            </Button>
          </div>
        );
      /**
       * 常用于审核底部按钮 驳回 通过
       */
      case '5':
        return (
          <div style={styleList.btn_page}>
            <Button
              disabled={disabled}
              style={{ ...styleList.btn_margin, ...styleList.btn, ...styleList.btn_reject }}

              onClick={btnOne}
              loading={isSumbitLoading && isSumbitLoading}>
              驳回
            </Button>
            <Button
              disabled={disabled}
              style={{ ...styleList.btn }}
              loading={isSumbitLoading && isSumbitLoading}
              type='primary'
              onClick={btnTwo}>
              通过
            </Button>
          </div>
        );
      /**
       * 常用于审核底部按钮 驳回 通过
       */
      case '6':
        return (
          <div style={styleList.btn_page}>
            <Button
              disabled={disabled}
              style={{ ...styleList.btn_margin, ...styleList.btn, ...styleList.btn_no }}
              onClick={btnOne}
              loading={isSumbitLoading && isSumbitLoading}>
              拒绝
            </Button>
            <Button
              disabled={disabled}
              style={{ ...styleList.btn }}
              loading={isSumbitLoading && isSumbitLoading}
              type='primary'
              onClick={btnTwo}>
              通过
            </Button>
          </div>
        );
      /**
       * 自定义按钮数量 样式 以及按钮内容
       */
      case '7':
        return (
          <div style={styleList.btn_page}>
            {btnList.length > 0
              ? btnList.map((item, index) => {
                return (
                  <Button
                    disabled={disabled}
                    key={index}
                    type={Item.type}
                    style={item.style}
                    onClick={item.click}
                    loading={isSumbitLoading && isSumbitLoading}
                    style={item.margin ? { ...styles.btn_margin, ...styleList.btn } : { ...styleList.btn }}
                  >
                    {item.content}
                  </Button>
                );
              })
              : ''}
          </div>
        );
      /**
       * 自定义单个组件按钮
       */
      case '8':
        return (
          <Button
            type={style === 'deafalut' ? 'primary' : ''}
            className={style !== 'deafalut' ? style : ''}
            style={{
              minHeight: 32,
              minWidth: 90,
              marginLeft: style === 'deafalut' ? 16 : '',
            }}
            onClick={btnOne}
            loading={!!isSumbitLoading}>
            {text}
          </Button>
        );
    }
  }
}
