/**
 * 提交按钮封装
 * 需要传入以下参数
 * form控件
 * appId 事务Id
 * draftId 草稿Id 可不传
 * callback 保存成功后执行函数
 */
import React, { Component } from 'react';
import { Button } from 'antd';
import AddModel from './AddModal';
import { preHandle } from '../../utils/myutils';
import { connect } from 'dva';
import { openToast } from '../../location/Notification';
import { isEmpty } from '../../copy';
@connect()
export default class idnex extends Component {
	constructor(props) {
		super(props);
		this.state = {
			visible: false,
			isLoading: false,
			draftId: props.draftId ?? '',
		};
	}
	componentWillReceiveProps(nextProps) {
		const { draftId } = nextProps;
		if (draftId) {
			// 接收到最新草稿Id更新
			this.setState({
				draftId,
			});
		}
	}
	showModal = () => {
		this.props.form.validateFields((err, values) => {
			if (!err) {
				this.setState({
					visible: true,
				});
			}
		});
	};
	handleOk = () => {
		let { dispatch, draftCode } = this.props;
		this.props.form.validateFields((err, values) => {
			if (!err) {
				preHandle(values); // 引入 import preHandle from '@/webPublic/one_stop_public/utils/myutils.js'
				console.log(values);
				this.setState(
					{
						isLoading: true,
					},
					() => {
						dispatch({
							type: 'affair/startProcess',
							payload: {
								content: JSON.stringify(values), // 表单数据
								appId: this.props.appId, // 这里应该由上级路由跳转传入 事务Id
								id: !!this.state.draftId ? this.state.draftId : null, // 确认是否存在草稿表单Id存在即传入
								code: typeof draftCode !== 'undefined' ? draftCode : null, // 确认是否存在草稿表单code存在即传入
							},
							callback: (val) => {
								if (val) {
									this.setState({
										draftId: val.id,
									});
									if (this.props?.callback) {
										this.props.callback(val);
									}
								}
							},
						}).then(() => {
							this.setState({
								isLoading: false,
								visible: false,
							});
						});
					},
				);
			} else {
				openToast('error', '提交失败', '请填写必填项');
			}
		});
	};
	handleCancel = () => {
		this.setState({
			visible: false,
		});
	};
	handleDraft = () => {
		let { dispatch, id, radioValue, draftCallback, draftCode } = this.props;
		this.setState(
			{
				isLoading: true,
			},
			() => {
				this.props.form.validateFields((err, values) => {
					if (!err) {
						preHandle(values); // 引入 import {preHandle} from '@/webPublic/one_stop_public/utils/myutils.js'
						dispatch({
							type: 'affair/saveDraft',
							payload: {
								content: JSON.stringify(values), // 表单数据
								appId: this.props.appId, // 这里应该由上级路由跳转传入 事务Id
								id: !!this.state.draftId ? this.state.draftId : null, // 确认是否存在草稿表单Id存在即传入
								code: typeof draftCode !== 'undefined' ? draftCode : null, // 确认是否存在草稿表单code存在即传入
							},
							callback: (val) => {
								if (isEmpty(val) === false) {
									this.setState({
										// 存在草稿后保存草稿Id 后续修改在这草稿Id上处理
										draftId: val.id,
									});
									if (this.props?.draftCallback) {
										this.props.draftCallback(val);
									}
									openToast('success', '保存成功', '草稿保存成功');
								} else {
									openToast('error', '保存失败', '请尝试');
								}
							},
						}).then((res) => {
							this.setState({
								isLoading: false,
							});
						});
					}
				});
			},
		);
	};
	render() {
		const { text, openDraftButton, DraftButtonText } = this.props;
		const { visible, isLoading } = this.state;
		return (
			<>
				{openDraftButton ? (
					<Button
						style={{
							marginRight: 24,
						}}
						shape="round"
						isLoading={isLoading}
						onClick={this.handleDraft}>
						{DraftButtonText ?? '暂存草稿'}
					</Button>
				) : null}
				<Button onClick={this.showModal} isLoading={isLoading} type="primary" shape="round" ghost>
					{text ?? '提交'}
				</Button>
				<AddModel
					visible={visible}
					handleOk={this.handleOk}
					loading={isLoading}
					handleCancel={this.handleCancel}
				/>
			</>
		);
	}
}
