import { Table, Popover } from 'antd';
import config from '@/webPublic/one_stop_public/config';
import table from '../assets/专家经验系统切图/智能报告/table.png';
import chart from '../assets/专家经验系统切图/智能报告/chart.png';
import React from 'react';
import { connect } from 'dva';
import { queryFileUrl } from '@/webPublic/one_stop_public/utils/queryConfig';
const ReactHighcharts = config.ReactHighcharts;

@connect(({ Report, loading }) => ({
	Report,
	loading: loading.models.Report,
}))
class ChartComponent extends React.Component {
	constructor(props) {
		super(props);
		this.state = {
			dataSource: [],
			columns: [],
			chartConfig: {},
		};
	}
	componentDidMount() {
		const { dispatch, data, userId } = this.props;

		dispatch({
			type: 'Report/getStatistics',
			payload: { ...data, studentId: userId },
			callback: (res) => {
				const { chartType, chartTitle } = data;
				if (chartType == '0') {
					this.setState({ ...res });
				} else {
					const cts = [];
					const series = [];
					const { columns, dataSource } = res;
					for (var i = 1; i < columns.length - 1; i++) {
						cts.push(columns[i].title);
					}

					for (var j = 0; j < dataSource.length - 1; j++) {
						const obj = dataSource[j];

						const ob = { name: obj[columns[0].dataIndex] };
						const dd = [];
						for (var i = 1; i < columns.length - 1; i++) {
							dd.push(obj[columns[i].dataIndex]);
						}
						ob.data = dd;
						series.push(ob);
					}
					const chartConfig = {
						chart: {
							type: chartType,
						},
						title: {
							text: chartTitle,
						},
						xAxis: {
							categories: cts,
						},
						tooltip: {
							pointFormat: '{series.name}: <b>{point.percentage:.1f}%</b>',
						},

						plotOptions: {
							line: {
								dataLabels: {
									// 开启数据标签
									enabled: true,
								},
								// 关闭鼠标跟踪，对应的提示框、点击事件会失效
								enableMouseTracking: false,
							},
						},
						series: series,
					};

					this.setState({ chartConfig });
				}
			},
		});
	}
	edit = () => {
		const { data, editKey, editBlock } = this.props;

		editBlock(true, editKey, data);
	};
	render() {
		const content = (
			<div>
				<a onClick={this.edit}>编辑</a>
			</div>
		);
		const { isView, data } = this.props;

		const { chartConfig, dataSource, columns } = this.state;
		const { chartType, chartTitle } = data;

		if (isView) {
			if (chartType == '0') {
				if (columns.length > 5) {
					columns[0].fixed = 'left';
					columns[0].width = 200;
					columns[0].title = chartTitle;
					for (var i = 1; i < columns.length; i++) {
						columns[i].width = 50;
					}
				}
				return (
					<div>
						<Table
							size="small"
							dataSource={dataSource}
							scroll={{ x: (columns.length - 1) * 50 + 200 }}
							columns={columns}
							pagination={false}
						/>
					</div>
				);
			} else {
				return <ReactHighcharts config={chartConfig} />;
			}
		} else {
			return (
				<Popover content={content}>
					<img src={chart} style={{ maxWidth: '100%' }} />
				</Popover>
			);
		}
	}
}

@connect(({ Report, loading }) => ({
	Report,
	loading: loading.models.Report,
}))
class TableComponent extends React.Component {
	constructor(props) {
		super(props);

		this.state = {
			dataSource: [],
			columns: [],
		};
	}
	componentDidMount() {
		const { dispatch, data, userId } = this.props;

		dispatch({
			type: 'Report/exportData',
			payload: { ...data, studentId: userId },
			callback: (res) => {
				this.setState({ ...res });
			},
		});
	}
	edit = () => {
		const { data, editKey, editBlock } = this.props;

		editBlock(false, editKey, data);
	};
	delete = () => {
		const { deleteBlock, editKey } = this.props;

		deleteBlock(editKey);
	};
	render() {
		const content = (
			<div>
				<a onClick={this.edit}>编辑</a>
			</div>
		);

		const { dataSource, columns } = this.state;
		const { isView } = this.props;

		return isView ? (
			<Table size="small" dataSource={dataSource} columns={columns} pagination={false} />
		) : (
			<Popover content={content}>
				<img src={table} style={{ maxWidth: '100%' }} />
			</Popover>
		);
	}
}

const AtomicComponent = (props) => {
	const { contentState, block } = props;
	const { isView, userId, editKey, editBlock, deleteBlock } = props.blockProps;

	const x = block.getEntityAt(0);
	if (x == null) {
		return <div />;
	}
	const entity = contentState.getEntity(x);

	const type = entity.getType();

	if (type === 'image') {
		const { src } = entity.getData();
		return (
			<div>
				<img src={queryFileUrl(src)} style={{ maxWidth: '100%' }} />
			</div>
		);
	}
	if (type === 'attr') {
		const { src, name } = entity.getData();
		return (
			<a href={queryFileUrl(src)} target="_blank">
				{name}
			</a>
		);
	} else if (type === 'video') {
		const { src } = entity.getData();
		return (
			<div>
				<video src={queryFileUrl(src)} controls="controls">
					您的浏览器不支持 video 标签。
				</video>
			</div>
		);
	} else if (type === 'table') {
		return <TableComponent data={entity.getData()} {...props.blockProps} />;
	} else if (type === 'chart') {
		return <ChartComponent data={entity.getData()} {...props.blockProps} />;
	}
};
export default function myBlockRenderer(isView, userId, editBlock, deleteBlock, contentBlock) {
	const type = contentBlock.getType();

	if (type == 'atomic') {
		return {
			component: AtomicComponent, // 指定组件
			editable: false, // 这里设置自定义的组件
			props: {
				isView: isView,
				userId: userId,
				editBlock: editBlock,
				deleteBlock: deleteBlock,
				editKey: contentBlock.getKey(),
			},
		};
	}
}
