/**
 * 徐立
 * 2019年9月19日
 * 查看详情页面
 */
import React, { Component, Fragment, useEffect, useState, useRef } from 'react';
import {
	Row,
	Col,
	Timeline,
	Icon,
	Form,
	Button,
	Spin,
	Radio,
	Popconfirm,
	Checkbox,
	Switch,
	InputNumber,
	message,
} from 'antd';
import Card from './components/Card';
import { getToken } from '@/webPublic/one_stop_public/utils/token';
import { connect } from 'dva';
import { isEmpty } from 'lodash';
import { openToast } from './components/Notification';
import PortalFlowExamineModal from './components/FlowExamineModal';
import BtnOk from '@/webPublic/one_stop_public/AffairButton/AuditButton/userTable';
import ZdyTable from '@/webPublic/one_stop_public/Table';
import moment from 'moment';
import SVG from './components/SVG';
import TrunToModel from './components/trunToModel';
import router from 'umi/router';
import { permRequest } from '@/webPublic/one_stop_public/utils/request';
import styles from './styles.less';
import TrunToDetail from './trunToDetail';
import Countersign from './components/Countersign';
import ChildTaskModel from './ChildTaskModel';
import {
	checkNeedFormValidateFieldsAndScroll,
	must,
	submitValues,
	checkNeedWriteAuditInfo,
} from './splitDetailSplit';
import {
	queryApiVersion,
	queryApiActionPath,
	queryFileUrl,
} from '@/webPublic/one_stop_public/utils/queryConfig';
import { getIsGui_Jian, isJSON } from '@/webPublic/zyd_public/utils/utils';
import HistoryFormList from '@/webPublic/one_stop_public/DetailForAudit/HistoryFormList';
import { getServicesNomal, getUaaServicesNomal } from '../Services/services';
import { getAllApi, getDetailsApi, queryUserSetApi } from '../Services/apiConfig';
import { getFormDetail } from "@/webPublic/FormInsertDiy/AffairPage/publicApiService";

@connect()
class DetailSplit extends Component {
	constructor() {
		super();
		this.state = {
			isTakeFlow: false,
			data: {}, // 详情数据
			stepFlow: [],
			items: [],
			obj: {},
			isSecond: false, // 如果为true,表示重新发起
			selects: new Map(),
			left: 0,
			top: 0,
			max: 4,
			width: 100,
			taskId: '', // 模型id
			appId: '', // 事务id
			code: '', // 事务code 当前表单唯一值
			isHandle: false, // 判断用户是否有权限
			id: '', // 表单id
			btns: [], // 自定义按钮
			taskFormKey: '', // 多表单显示的key
			itemsOK: [], // 多表单显示的表单
			hisTaskFormKeys: {}, // 历史任务相关
			isLoading: false, // 请求状态
			formColor: '', // 流程紧急度颜色
			formLevel: '', // 流程文本
			btnList: [], // 紧急度按钮返回数据
			radiovalue: '', // 单选id
			isEnd: false, // 是否结束
			isShowTitle: true, // 是否展示流程步骤几个字
			isSumbitLoading: false, // 发起时触发
			isOpenTrunToModel: false, // 用户转办,回收弹框控制变量
			trunToStatus: '转办', // 当前节点存在状态
			trunData: '', // 转办当前选中数据
			isCloseUserDetail: false, // 是否展示用户基础详细信息
			checkedConfimList: [], // 用户选择打印元素
			checkListOptions: [], // 历史表单复选框存放值
			isShowTitleTwo: true, // 历史表单展示状态
			paddingBottom: 0,
			isSign: false, // 是否使用签名
			userInfo: '', // 得到用户数据
			setData: '', // 配置的数据
			countersignModal: '', // 开启加签弹框函数
			isAllPrint: false,
			closeAutoSign: false, // 28521 退役大学生评优管理/在校退役大学生评优审核，去掉审核签名
		};
		window.callbackSubmitInfoZhiYong = undefined;
	}

	/**
	 * @function 同步加签函数
	 * @param { function } func 打开加签弹框函数
	 */
	updateCountersignModal = (func) => {
		this.setState({
			countersignModal: func,
		});
	};
	/**
	 * 关闭转办,回收弹框
	 */
	handleTrunToModel = () => {
		this.setState({
			isOpenTrunToModel: false,
			trunData: '',
			trunToStatus: '',
		});
	};

	/**
	 * 打开转办,回收弹框
	 * @param { string } text 当前按钮状态
	 */
	showTrunToModel = (text, record) => {
		this.setState({
			isOpenTrunToModel: true,
			trunToStatus: text,
			trunData: record,
		});
	};

	examineFlow = (...ags) => {
		this.flowExamineModal.showModal(...ags);
	};

	getTaskInfos = (res) => {
    const queryId = this.props.history.location.query && this.props.history.location.query.id;
    const id = this.props.history.location.state && this.props.history.location.state.id;
    const code = this.props.history.location.state && this.props.history.location.state.code;
    if(queryApiVersion() === '2.0'){
      return new Promise((resolve) => {
        resolve(res);
      });
    }
    return permRequest('/UnifiedAppFormApi/getTaskInfos', {
      // 获取每一步的审核人.
      id: queryId ? queryId : id, // 审批表Id
      code: code || null, // 表单值
    });
  };

  goPrintDiy = () => {
    router.push({
      pathname: '/xg/grade/help/PKSRD/DiyPrint',
      state: {
      },
      query: {
        code: this.state.code,
      },
    });
  };

	componentDidMount() {
		this.getInit();

		if (this.props.onRef) {
			this.props.onRef(this);
		}
	}

	/**
	 * @function 默认请求
	 */
	getInit = (handleUser) => {
		const { formPrepareData } = this.props;
		const id = this.props.history.location.state && this.props.history.location.state.id;
		const code = this.props.history.location.state && this.props.history.location.state.code;
		const queryId = this.props.history.location.query && this.props.history.location.query.id;
		if (!id && !code) {
			if (queryId) {
			} else {
				openToast('error', '数据已过期', '当前页面数据已过期,请重新进入');
				router.push('/portal/home');
				return;
			}
		}
		const val = formPrepareData;
		if (val) {
			if (this.props.changeData) {
				this.props.changeData(val);
			}
			const checkListOptions = [];
			const checkedConfimList = [];
			if (val?.hisTaskForm?.formKeys) {
				val.hisTaskForm.formKeys.map((item) => {
					checkListOptions.push({
						label: item.taskName,
						value: item.formKey,
					});
				});
			}
			if (val) {
        this.getTaskInfos(val).then((res) => {
					val.taskInfo = res.taskInfo;
					if(res.taskInfo && res.taskInfo.length > 1){
					  if(res.taskInfo[0].taskDefKey === res.taskInfo[res.taskInfo.length - 1].taskDefKey
              && !val.hisTaskForm.formKeys?.length
              // 1. 需要解决申请人查看不到已驳回的表单数据
              // 2. 需要解决审批人查看不到已驳回的表单数据
              // 3. 如果还有问题找欢哥解决 2024年9月23日 14:37:28
            ) {
					    // 正在处理的 且是自己的 2024年9月23日 姚鑫国钉钉消息喊改的. 家庭经济困难普查申请 - 学生账号 20242608012
					    const formKey = res.taskInfo[0].formKey;
					    // 驳回到发起节点没有展示的bug-3673 查看已驳回的数据的详情，无数据显示
              val.taskFormKey = formKey;
              val.hisTaskForm.formKeys = [
                {
                  formKey: formKey,
                  taskName: res.taskInfo[0].name,
                },
              ];
            }
          }
					this.setState(
						{
							data: val,
							stepFlow: val.taskInfo,
							obj: JSON.parse(val.content),
							taskId: val.taskId,
							isSecond: val.isSecond ? val.isSecond : false,
							appId: val.appId,
							code: val.code,
							isHandle: val.isHandle,
							id,
							btns: val.btns,
							taskFormKey: val.taskFormKey,
							hisTaskFormKeys: val.hisTaskForm,
							isLoading: true,
							formColor: val.formColor,
							formLevel: val.formLevel,
							isEnd: val.isEnd,
							checkListOptions,
							checkedConfimList,
						},
						() => {
							if (val.isSecond) {
								getUaaServicesNomal(getAllApi, {}).then(arr => {
									this.setState(
										{
											btnList: arr,
											radiovalue: val.formLevelId ? val.formLevelId : arr[arr.length - 1].id,
										},
										() => {
											// this.giveMessageTop();
										},
									);
								})
							} else {
								// this.giveMessageTop();
							}
						},
					);
				});
			}
		}
		getUaaServicesNomal(getDetailsApi, {
			configKeys: ['isCloseUserDetail', 'isCloseFlowPath', 'isAllPrint', 'closeAutoSign'],
		}).then(val => {
			const closeAutoSign = !!(val[3] && val[3].configValue === 'true');
			this.setState({
				isCloseUserDetail: !!(val[0] && val[0].configValue === 'true'),
				isAllPrint: !!(val[2] && val[2].configValue === 'true'),
				closeAutoSign,
			});
			if (!closeAutoSign) {
				/**
				 * 获取设置的数据
				 */
				getServicesNomal(queryUserSetApi, {}).then(val => {
					this.setState({
						setData: val,
					});
				});
			}

			if (val[1]?.configValue) {
				sessionStorage.setItem(
					'isCloseFlowPath',
					val[1]?.configValue === 'true' ? JSON.stringify(true) : JSON.stringify(false),
				);
			}
		});
		if (getToken()) {
			const user = localStorage.getItem('user');
			if (user && isJSON(user)) {
				this.setState({
					userInfo: JSON.parse(user),
				});
			}
		}
	};

	/**
	 * @function 用户点击确认执行相应操作
	 * @description: 注意 用户点击状态时在点击动态配置按钮时进行了保存,并在该函数中最终提交给后端
	 * @param { string } oldkey 按钮状态
	 * @param { string } btnValue 按钮选中状态
	 * @param { string } value 审批理由
	 * @param { boolean } checked 加签状态
	 * @param { function } callback 回调函数
	 */
	affairOk = (oldkey, btnValue, value, checked, callback) => {
		const { dispatch } = this.props;
		const { radiovalue, isSecond, userInfo, setData, data, btns, taskId, code } = this.state;
		const { handleUser } = this.props.history.location.state;
		const isCloseFlowPath = sessionStorage.getItem('isCloseFlowPath')
			? JSON.parse(sessionStorage.getItem('isCloseFlowPath'))
			: false;
		if (callback) {
			callback();
		}

		let checkSumbitInfo = checkNeedFormValidateFieldsAndScroll({
			// 检查是否必填表单值
			btns,
			btnValue,
		});

		let needWriteAuditInfo = checkNeedWriteAuditInfo({
			// 检查是否必填审批理由
			btns,
			btnValue,
		});
		if (needWriteAuditInfo && !value) {
			let d = document.getElementById('textarea_shen_pi_li_you');
			if (d) {
				message.warning('请输入审批理由');
				return false;
			}
		}
		const argumentsSubmitValue = {
			isCloseFlowPath,
			radiovalue,
			isSecond,
			taskId,
			code,
			btnValue,
			oldkey,
			value,
			checked,
			setData,
			data,
			userInfo,
			btns,
			dispatch,
			that: this,
			handleUser,
		};

		if (!checkSumbitInfo) {
			// 如果不需要校验 直接提交数据
			const values = this.props.form.getFieldsValue();
			argumentsSubmitValue.values = values;
			submitValues(argumentsSubmitValue);
		} else {
			this.props.form.validateFieldsAndScroll((err, values) => {
				// 校验是否填了必填字段
				if (!err) {
					argumentsSubmitValue.values = values;
					submitValues(argumentsSubmitValue);
				}
			});
		}
	};

	onChange = (e) => {
		this.setState({
			radiovalue: e.target.value,
		});
	};

	/**
	 * @function 复选框状态函数
	 * @event change
	 */
	onCheckChange = (checkedValues) => {
		this.setState({
			checkedConfimList: checkedValues,
		});
	};
	/**
	 * @function 加签点击函数
	 * @event click
	 */
	onClickCountersign = () => {
		const { countersignModal } = this.state;
		countersignModal();
	};
	/**
	 * @function 通过用户复选框选择拼装为对应打印页面
	 */

	changeTake = (checked) => {
		this.setState({ isTakeFlow: checked });
	};

	changePadding = (value) => {
		this.setState({ paddingBottom: value });
	};

	goOtherDetail = (e) => {
		const code = e.currentTarget.dataset.codeId;
		let url = window.location.href.split('#')[0];
		if (code) {
			window.open(
				url + '#' + this.props.history.location.pathname + '?code=' + code + '&showAll=false',
			);
		}
	};

	render() {
		const {
			stepFlow,
			isHandle,
			hisTaskFormKeys,
			id,
			appId,
			code,
			steps,
			data,
			btns,
			isSecond,
			isLoading,
			formColor,
			formLevel,
			btnList,
			radiovalue,
			isEnd,
			isShowTitle,
			isSumbitLoading,
			isOpenTrunToModel,
			trunToStatus,
			trunData,
			isCloseUserDetail,
			checkListOptions,
			checkedConfimList,
			isTakeFlow,
			paddingBottom,
			setData,
			isSign,
			isAllPrint,
			closeAutoSign, // 28521 退役大学生评优管理/在校退役大学生评优审核，去掉审核签名
		} = this.state;
		const { showPrint } = this.props;
		const isCloseFlowPath = sessionStorage.getItem('isCloseFlowPath')
			? JSON.parse(sessionStorage.getItem('isCloseFlowPath'))
			: true;
		const isTrunTo = sessionStorage.getItem('isTrunTo')
			? JSON.parse(sessionStorage.getItem('isTrunTo'))
			: false;
		const domainName = sessionStorage.getItem('domainName')
			? sessionStorage.getItem('domainName')
			: '';
		const routerState = {
			history: this.props?.history,
			location: this.props?.location,
			match: this.props?.match,
			computedMatch: this.props?.computedMatch,
			route: this.props?.route,
		};

		return (
			<Fragment>
				<div
					style={{
						width: '100%',
						display: 'flex',
						justifyContent: 'center',
						minHeight: '50px',
					}}>
					<div style={{ width: '100%' }}>
						<div
							className={styles.header}
							style={{
								position: 'relative',
							}}>
							{isCloseFlowPath ? null : ( // 关闭流程紧急度显示
								<span
									style={
										{
											// position: 'absolute',
											// left: 0,
											// top: '30%',
										}
									}>
									{isSecond ? (
										<>
											<span style={{ marginRight: 12 }}>
												{must}
												流程紧急度
											</span>
											<Radio.Group onChange={this.onChange} value={radiovalue}>
												{btnList.length > 0
													? btnList.map((item) => (
															<Radio key={item.id + Math.random()} value={item.id}>
																<span style={{ color: item.color }}>{item.name}</span>
															</Radio>
													  ))
													: ''}
											</Radio.Group>
										</>
									) : (
										<>
											紧急程度:
											<span
												style={{
													color: formColor || '',
													marginLeft: 21,
												}}>
												{formLevel || '暂无'}
											</span>
										</>
									)}
								</span>
							)}

							{data.appName ? data.appName : '当前表单'}

              { // 姚鑫国 喊加的 http://scjoyedu.eicp.net:57400/zentao/task-view-3712.html
                window.zdyTableTemplateWillMountProps &&
                window.zdyTableTemplateWillMountProps.applyDetailsBtns &&
                  <div className={styles.buttons} data-info={'DetailSplit-543'}>
                    {
                      window.zdyTableTemplateWillMountProps.applyDetailsBtns.map((item) => {
                        return (
                          <Button key={item.children} {...item} />
                        )})
                    }
                  </div>
              }
							{(isEnd || isAllPrint) &&
								showPrint !== false &&
								appId !== '1328230407929331712' && (
									<>
										<Popconfirm
											onConfirm={() => {
												if (!checkedConfimList || !checkedConfimList.length) {
													message.warning('请选择需要打印的表单');
													return false;
												}
												if (domainName) {
													window.open(
														`${domainName}/protal/printRouter?id=${data.id}&list=${JSON.stringify(
															checkedConfimList,
														)}&padding=${paddingBottom}&isTakeFlow=${isTakeFlow}&token=${getToken()}`,
													);
												} else {
													openToast('warning', '未配置域名地址,请联系管理员');
												}
											}}
											title={
												<div>
													<div>
														是否带流程:
														<Switch checked={isTakeFlow} onChange={this.changeTake} />
													</div>
													<div>
														表单间距:
														<InputNumber
															min={0}
															size="small"
															value={paddingBottom}
															onChange={this.changePadding}
														/>
													</div>
													<div className={styles.history_form_title}>请选择需要打印的表单</div>
													<div className={styles.history_form_body_div}>
														<Checkbox.Group
															options={checkListOptions}
															onChange={this.onCheckChange}
															defaultValue={checkedConfimList}
														/>
													</div>
												</div>
											}
											okText="确定"
											cancelText="取消">
											{(data.isPrint == null || data.isPrint || isAllPrint) &&
											showPrint !== false ? (
												<Button
													style={{
														position: 'absolute',
														right: 200,
														top: '30%',
													}}
													type="primary">
													打印预览
												</Button>
											) : (
												''
											)}
										</Popconfirm>
									</>
								)}
							{appId === '1328230407929331712' &&
								getIsGui_Jian() && (
									<Button
                    onClick={this.goPrintDiy}
										style={{
											position: 'absolute',
											right: 200,
											top: '30%',
										}}
										type="primary">
										打印预览
									</Button>
								)}
						</div>
					</div>
				</div>
				{isLoading ? (
					<>
						<Card style={{ width: '100%' }}>
							{!isCloseUserDetail && (
								<div className={styles.body_hea}>
									<h3>发起人信息</h3>
									{data &&
										(data.createTime ||
											data.code ||
											data.userName ||
											data.userPosition ||
											data.userPhone ||
											data.userSchool) && (
											<Row className={styles.row}>
												{data &&
													data.code && (
														<Col
															style={{
																marginBottom: 12,
															}}
															span={8}>
															<span className={styles.hea_title}>单号：</span>
															<span className={styles.hew_content}>{data.code}</span>
														</Col>
													)}
												{data &&
													data.userName && (
														<Col
															style={{
																marginBottom: 12,
															}}
															span={8}>
															<span className={styles.hea_title}>用户姓名：</span>
															<span className={styles.hew_content}>{data.userName}</span>
														</Col>
													)}
												{data &&
													data.userPosition && (
														<Col
															style={{
																marginBottom: 12,
															}}
															span={8}>
															<span className={styles.hea_title}>职位：</span>
															<span className={styles.hew_content}>{data.userPosition}</span>
														</Col>
													)}
												{data &&
													data.userSchool && (
														<Col
															span={8}
															style={{
																marginBottom: 12,
															}}>
															<span className={styles.hea_title}>学院/单位：</span>
															<span className={styles.hew_content}>{data.userSchool}</span>
														</Col>
													)}
												{data &&
													data.userPhone && (
														<Col
															span={8}
															style={{
																marginBottom: 12,
															}}>
															<span className={styles.hea_title}>联系电话：</span>
															<span className={styles.hew_content}>{data.userPhone}</span>
														</Col>
													)}
												{data &&
													data.createTime && (
														<Col
															style={{
																marginBottom: 12,
															}}
															span={8}>
															<span className={styles.hea_title}>申请时间：</span>
															<span className={styles.hew_content}>
																{moment(data.createTime).format('YYYY-MM-DD HH:mm')}
															</span>
														</Col>
													)}
											</Row>
										)}
								</div>
							)}
							{// 关联流程 禅道 29126
							Array.isArray(data.pcodeData) &&
								data.pcodeData.length && (
									<div className={styles.body_hea}>
										<h3>关联流程</h3>
										<div className={styles.guanLianLiuCheng}>
											{data.pcodeData.filter((x) => !!x.code).map((g) => {
												return (
													<a key={g.code} onClick={this.goOtherDetail} data-code-id={g.code}>
														{g.appName}
													</a>
												);
											})}
										</div>
									</div>
								)}
							<div
								className={styles.HistoryFormList}
								id="card_table"
								ref={(el) => (this.componentRef = el)}
								style={{ padding: !isShowTitle ? '50px' : '' }}>
								<HistoryFormList
									data={data}
									formKeys={hisTaskFormKeys?.formKeys}
									isShowTitle={isShowTitle}
									routerState={routerState}
									formData={hisTaskFormKeys?.formData}
								/>
								{isHandle === true &&
									!!data.taskFormKey && (
										<>
											{isShowTitle ? (
												<h3
													style={{
														display: 'flex',
														alignItems: 'center',
													}}>
													<SVG name="vertical" color="#999999" height="24" />
													当前流程
												</h3>
											) : (
												''
											)}
											{isEmpty(data) === false ? (
												<ZdyTable
													key={data.taskFormKey}
													postData={data}
													get="web"
													obj={hisTaskFormKeys.formData}
													table="new"
													form={this.props.form}
													routerState={routerState}
												/>
											) : (
												''
											)}
										</>
									)}
							</div>
						</Card>
						<Card style={{ width: '100%' }}>
							<div className={styles.body_content} style={{ minHeight: '300px' }}>
								<div id={'btnsModalMountDiv'} />
								<h3>
									审批状态 <span onClick={this.examineFlow}>查看流程图</span>
								</h3>
								<div
									ref={(el) => (this.componentTwoRef = el)}
									style={{
										padding: !isShowTitle ? '0 50px 50px 50px' : '',
									}}>
									<Timeline>
										{stepFlow !== '' && steps !== ''
											? stepFlow.map((item, index) => {
													if (index === stepFlow.length - 1) {
														// 最后一步流程
														return (
															<Timeline.Item
																color={['处理中', '待处理'].includes(item.status) ? 'red' : '#ccc'}
																dot={
																	<Icon
																		type={
																			['处理中', '待处理'].includes(item.status)
																				? 'clock-circle-o'
																				: 'check-circle'
																		}
																		style={{ fontSize: '16px' }}
																	/>
																}
																className={styles.steps_step}
																key={item.id}>
																<p className={styles.steps_title}>
																	{item.assignee}
																	<span>
																		{item.endTime
																			? moment(item.endTime).format('YYYY-MM-DD HH:mm')
																			: '处理中'}
																	</span>
																</p>
																{queryApiVersion() === '2.0' &&
																	['处理中', '待处理'].includes(item.status) &&
																	!!data.nextUsers && <p>审批人员: {data.nextUsers}</p>}
																{queryApiVersion() !== '2.0' &&
																	['处理中', '待处理'].includes(item.status) &&
																	!!item.nextUsers && <p>审批人员: {item.nextUsers}</p>}
																<p>
																	审批流程：
																	{item.name}
																</p>
																<p className={styles.steps_body}>
																	审批状态：
																	{item.status}
																</p>
																{item.taskVariable?.reason ? (
																	<p>
																		审批原因：
																		{item.taskVariable?.reason}
																	</p>
																) : (
																	''
																)}
																{item.childTaskModel &&
																	item.childTaskModel.length > 0 && (
																		<ChildTaskModel data={item.childTaskModel} />
																	)}

																{(isSign || item.taskVariable?.sign) && !closeAutoSign ? (
																	<img
																		style={{
																			position: 'absolute',
																			top: '50%',
																			left: 200,
																			height: 50,
																			marginTop: -25,
																			border: item.taskVariable?.sign ? '1px solid #ccc' : '',
																		}}
																		src={queryFileUrl(item.taskVariable?.sign)}
																		alt=""
																	/>
																) : (
																	''
																)}
																{isTrunTo && +item.commentCount > 0 ? (
																	<TrunToDetail data={data} item={item} />
																) : null}
															</Timeline.Item>
														);
													}
													return (
														<Timeline.Item
															color={item.status === 0 ? 'gray' : 'green'}
															dot={
																item.status === 0 ? (
																	''
																) : (
																	<Icon
																		type="check-circle"
																		theme="twoTone"
																		twoToneColor="#52c41a"
																	/>
																)
															}
															className={styles.steps_step}
															key={item.id}>
															<p className={styles.steps_title}>
																{item.assignee}
																<span>
																	{item.endTime
																		? moment(item.endTime).format('YYYY-MM-DD HH:mm')
																		: null}
																</span>
															</p>
															<p>
																审批流程：
																{item.name}
															</p>
															<p className={styles.steps_body}>
																审批状态：
																{item.status}
															</p>
															{item.taskVariable?.reason ? (
																<p>
																	审批原因：
																	{item.taskVariable.reason}
																</p>
															) : (
																''
															)}
															{item.childTaskModel &&
																item.childTaskModel.length > 0 && (
																	<ChildTaskModel data={item.childTaskModel} />
																)}
															{item.taskVariable?.sign ? (
																<img
																	style={{
																		position: 'absolute',
																		top: '50%',
																		left: 200,
																		height: 50,
																		marginTop: -25,
																		border: item.taskVariable?.sign ? '1px solid #ccc' : '',
																	}}
																	src={queryFileUrl(item.taskVariable?.sign)}
																	alt=""
																/>
															) : (
																''
															)}
															{isTrunTo && +item.commentCount > 0 ? (
																<TrunToDetail data={data} item={item} />
															) : null}
														</Timeline.Item>
													);
											  })
											: ''}
									</Timeline>
								</div>
							</div>
						</Card>
						<div className={styles.buttonList}>
							{isHandle === true ? (
								<>
									<BtnOk // 审批按钮和弹窗
										Sign={!!setData?.userSign}
										isSumbitLoading={isSumbitLoading}
										isSecond={isSecond}
										affairOk={this.affairOk}
										form={this.props.form}
										btns={btns}
										addition={
											<>
												{isTrunTo && data.isSecond !== true && isHandle ? (
													<Button
														style={{
															marginLeft: 16,
															minHeight: 32,
															minWidth: 90,
														}}
														onClick={() => {
															this.showTrunToModel(
																data.isHandle && data.isOwner
																	? '转办'
																	: !data.isHandle && data.isOwner
																		? '撤回'
																		: '回退',
																data,
															);
														}}
														type="primary">
														{data.isHandle && data.isOwner
															? '转办'
															: !data.isHandle && data.isOwner
																? '撤回'
																: data.isHandle && !data.isOwner
																	? '回退'
																	: null}
													</Button>
												) : null}
												{data.isCanSign && (
													<Button
														style={{
															marginLeft: 16,
															minHeight: 32,
															minWidth: 90,
														}}
														onClick={this.onClickCountersign}
														type="primary">
														加签
													</Button>
												)}
											</>
										}
									/>
								</>
							) : (
								''
							)}
							{isTrunTo &&
								data.isSecond !== true &&
								!data.isHandle &&
								data.isOwner && (
									<div
										style={{
											width: '100%',
											textAlign: 'center',
										}}>
										<Button
											style={{
												minHeight: 32,
												minWidth: 90,
												margin: '0 auto',
											}}
											onClick={() => {
												this.showTrunToModel('撤回', data);
											}}
											type="primary">
											撤回
										</Button>
									</div>
								)}
						</div>
					</>
				) : (
					<div
						style={{
							width: '100%',
							height: 200,
							display: 'flex',
							justifyContent: 'center',
							alignItems: 'center',
						}}>
						<Spin size="large" spinning={true} />
					</div>
				)}
				<PortalFlowExamineModal // 流程图
					ref={(node) => (this.flowExamineModal = node)}
					affairId={id}
					id={appId}
					code={code}
				/>
				<TrunToModel //
					visible={isOpenTrunToModel}
					handleCancel={this.handleTrunToModel}
					status={trunToStatus}
					value={trunData}
					init={this.getInit}
				/>
				{data?.appName && ( // 加签
					<Countersign
						taskId={data.taskId}
						data={data}
						getInit={this.getInit}
						updateCountersignModal={this.updateCountersignModal}
					/>
				)}
			</Fragment>
		);
	}
}

function Index(props) {
	const { dispatch, history } = props;
	const [prepare, setPrepare] = useState(false);
	const DetailSplitFormNew = useRef();
	useEffect(() => {
		getFormDetailData();
	}, []);

	const getFormDetailData = () => {
		const id = history.location.state && history.location.state.id;
		const code = history.location.state && history.location.state.code;
		const queryId = history.location.query && history.location.query.id;
		const queryCode = history.location.query && history.location.query.code;
		const taskId = history.location.state && history.location.state.taskId;
		if (!id && !code) {
			if (queryId) {
			} else {
				openToast('error', '数据已过期', '当前页面数据已过期,请重新进入');
				return;
			}
		}
		message.info('正在加载数据，请等待。');
		dispatch({
			type: 'affair/getIdFormDetail',
			payload: {
				id: queryId || id || undefined, // 审批表Id
				code: queryCode || code || null, // 表单值
				handleUser: null, // 处理人
				taskId, // 多任务流程会使用到,后续改为必须传入
				lite: true,
			},
			callback: (val) => {
				message.destroy();
				if (val) {
					DetailSplitFormNew.current = Form.create(
						window.zdyTableTemplateWillMountProps?.formCreateOptions || undefined,
					)(DetailSplit);
					setPrepare(val);
				}
			},
		});
	};

	if (!prepare) {
		return <Spin size="large" spinning={true} />;
	}
	return (
		<DetailSplitFormNew.current
			{...props}
			formPrepareData={prepare}
			getFormDetailData={getFormDetailData}
		/>
	);
}

export default connect(() => {
	return {};
})(Index);
