/**
 * 钟是志
 * 2019年12月11日 17:30:41
 * 查看详情页面的iframe嵌套到中医大里面
 */
import React, { Component } from 'react';
import { setToken } from '@/webPublic/one_stop_public/utils/token';
import { getUrlInfo } from './utils';
import DetailSplit from './DetailSplit';
import styles from './styles.less';
import { getOneStopConfigList } from '@/webPublic/one_stop_public/publicServices';

export default class GetDetail extends Component {
	constructor(props) {
		super(props);
		const token = getUrlInfo().token;
		if (token && token.length > 10) {
			setToken(token);
		}
		getOneStopConfigList();
		this.state = {
			id: getUrlInfo().id || props.id,
			code: getUrlInfo().code || props.code,
		};
	}

	componentDidMount() {}

	/***
	 * 需要加入跳转功能;
	 * 钟是志
	 * 在iframe中打开时 直接返回一个postMessage;
	 * */

	render() {
		const { id, code } = this.state;
		const {
			detailInfoDivStyle = {
				backgroundColor: '#FFFFFF',
				overflow: 'auto',
				height: '100%',
				width: 'calc(100vw - 300px)',
				padding: 0,
        margin: '0 auto',
			},
		} = this.props;
		let { location } = this.props.history;
		location = {
			...location,
			state: {
				id,
        code,
        taskId: location.state && location.state.taskId || undefined,
				fromIframe: false,
			},
		};
		return (
			<div className={styles.detail_div} id={'detailInfoDiv'} style={detailInfoDivStyle}>
				<DetailSplit
					history={{
						...this.props.history,
						location,
					}}
					showPrint={this.props.showPrint || false}
				/>
			</div>
		);
	}
}
