import React from 'react';
import { Col, Row } from 'antd';
import classNames from 'classnames/bind';
import PortalFlowExamineModalImage from './Image';
import { connect } from 'dva';
import { queryApiActionPath } from '@/webPublic/one_stop_public/utils/queryConfig';
import { getToken } from '@/webPublic/one_stop_public/utils/token';

const names = classNames.bind(require('./style.less'));
const Body = ({ className, ...props }) => <div className={names('body', className)} {...props} />;

@connect()
export default class PortalFlowExamineModalContent extends React.Component {
	constructor() {
		super();
		this.state = {
			data: {}, // 事务所有数据
			arr: [], // 事务流程
		};
	}

	render() {
		let { id, affairId, code } = this.props;
		let url = `${queryApiActionPath()}/UnifiedAppFormApi/getProcessImg?appId=${id}&token=${getToken()}`;
		if(affairId){
      url = url + `&id=${affairId}`;
    }
		return (
			<Row className={names('warp')}>
				<Col span={24}>
					<Body>
						{id % 2 === 1 ? (
							<PortalFlowExamineModalImage
								appid={id}
								code={code}
								src={url}
							/>
						) : (
							<PortalFlowExamineModalImage
								appid={id}
								code={code}
                src={url}
              />
						)}
					</Body>
				</Col>
			</Row>
		);
	}
}
