import React from 'react';
import Loading from '../loadThree';
import { Slider, Row, Col } from 'antd';
import { connect } from 'dva';
import classNames from 'classnames/bind';
import { getUaaServicesNomal } from '../../../Services/services';
import { getDetailsApi } from '../../../Services/apiConfig';

const names = classNames.bind(require('./style.less'));

let width;
let sliNum = 0;



@connect()
export default class PortalFlowExamineModalImage extends React.Component {
  state = {
    visible: true,
    slider: 0,
    isImgLoading: true,
    canvasIMg: '', // canvas转换的图片
    configValue: false, // 配置信息
    flowInfo: '', // 获取流程图的信息
  };

  handleCancel = () => this.setState({ visible: false });

  handlePreview = () => {
    // const {width} = this.img;
    // this.setState({visible: true, width})
  };

  sliderChange = num => {
    if (sliNum === 0) {
      width = document.querySelector('.img').width;
    }
    sliNum++;
    if (num == 0 && sliNum != 0) {
      document.querySelector('.img').width = width;
      return;
    }
    if (num > 0) {
      document.querySelector('.img').width = width * `${1}.${num}`;
    } else {
      document.querySelector('.img').width = width * `${0}.${Math.abs(num + 10)}`;
    }
  };

  getCanvasImg = imgSrc => {
    this.setState(
      {
        canvasIMg: imgSrc,
      },
      () => {
        this.setState({
          visible: false,
        });
      },
    );
  };

  componentDidMount = () => {
    const { appid, code } = this.props;
    this.props.dispatch({
      // 获取配置信息
      type: 'DataGgEditor/getNewProcessImg',
      payload: {
        appid,
        code,
      },
      callback: val => {
        this.setState({
          flowInfo: val,
        });
      },
    });
    // 获取配置信息
    getUaaServicesNomal(getDetailsApi, {
      configKeys: 'IsOldFlow',
    }).then(val => {
      this.setState({
        configValue: val[0].configValue == 'true',
      });
    });
  };

  onLoad = () => {
    this.setState({
      isImgLoading: false,
      visible: false,
    });
  };




  render() {
    const { src, appid } = this.props;
    const { visible, width, isImgLoading, canvasIMg, configValue, flowInfo } = this.state;
    const GetEditor = () => {
      if(flowInfo?.model?.id && isImgLoading){
        const GgEditor = require('../ggEditor');
        return GgEditor;
      }else{
        return null;
      }

    }

    return (
      <>
        {configValue ? (
          <div
            className={names('image-warp')}
            style={{ overflow: 'hidden', width: '1300px', height: '630px' }}
          >
            {flowInfo?.model?.id ? (
              <>
                <div
                  style={{
                    width: '100%',
                    height: '630px',
                    textAlign: 'center',
                    overflow: 'auto',
                  }}
                >
                  <img onLoad={this.onLoad} src={canvasIMg}></img>
                </div>
                {flowInfo?.model?.id && isImgLoading ? (
                  <div
                    style={{
                      width: '1600px',
                      height: '670px',
                      visibility: 'hidden',
                      position: 'relative',
                    }}
                  >
                    <GetEditor
                      flowModelId={flowInfo.model.id}
                      taskKeys={flowInfo.taskKeys}
                      getCanvasImg={this.getCanvasImg}
                      isShow={false}
                    />
                  </div>
                ) : null}
              </>
            ) : (
              <div style={{ marginTop: '350px' }}>
                {' '}
                <Loading />
              </div>
            )}
          </div>
        ) : (
          <div className={names('image-warp')}>
            <Row>
              <Col span={6} style={{ paddingLeft: 24, lineHeight: '36px' }}>
                图片展示比例:
              </Col>
              <Col span={6}>
                <Slider defaultValue={0} max={5} min={-5} onChange={this.sliderChange} />
              </Col>
            </Row>
            <div
              style={{
                display: isImgLoading ? 'none' : 'block',
              }}
            >
              <img
                onLoad={this.onLoad}
                className="img"
                src={src}
                style={{ overflow: 'auto', transition: 'all 0.5s', position: 'relative' }}
                ref={node => (this.img = node)}
                alt=""
                onClick={this.handlePreview}
              />
            </div>
            {isImgLoading ? (
              <div
                style={{
                  width: '90%',
                  height: '610px',
                  display: 'flex',
                  justifyContent: 'center',
                  alignItems: 'center',
                  paddingLeft: '10%',
                }}
              >
                <Loading />
              </div>
            ) : null}
            {/* <Modal
            width={width >= 1200 ? 1200 : width}
            wrapClassName={names("image-modal-warp")}
            visible={visible} footer={null}
            onCancel={this.handleCancel}
            destroyOnClose
          >
            <img alt="example" style={{ width: '100%' }} src={src} />
          </Modal> */}
          </div>
        )}
      </>
    );
  }
}
